<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1>Package Detail</h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active"><?php echo trim($breadcrumb, '/ ') ?></li>
        </ol> 
    </div>
</section>
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <div class="package_block fixBox" style="border:1px solid red;">   
                    <?php echo $package_detail['description'] ?>
                    <p><big>$<?= $package_detail['price'] ?></big> + Taxes</p>
                </div>
            </div>
            <div class="col-md-6">
                <form class="form-inline" id="package_form" method="post" action="<?= site_url('add-cart-package-item') ?>">
                    <div class="price_form">
                        <h3>You have entered no of people for this package :
                            <?php echo $no_of_people ?></h3>
                        <input type="submit" name="submit" value="Add to Cart" class="btn btn-primary pull-right">
                        <input type="hidden" name="no_of_people" id="no_of_people" value="<?php echo $no_of_people ?>">
                    </div>
                    <div class="clearfix"></div><br>
                    <?php
                    $char = A;
                    foreach ($pkg_category_data as $pkg_category) {
                        $package_specifications = $this->package->getPackageSpecificationsByCategoryPeople($package_detail['package_id'], $pkg_category['pkg_cat_id'], $no_of_people);
                        if ($package_specifications) {
                            ?>
                            <div class="panel panel-primary">
                                <div class="panel-heading"><big><?php echo $char ?></big></div>
                                <div class="panel-body">
                                    <div class="form-group">
                                        <label><?php echo $pkg_category['pkg_cat_name'] ?></label>
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table my_table">
                                            <?php
                                            $has_default=0;
                                            foreach ($package_specifications as $package_specification) {
                                                $item_name = $this->common_model->getSingleFieldFromAnyTable('item_name', 'pkg_item_id', $package_specification['item_id'], 'tbl_package_items');
                                                
                                                ?>
                                                <tr>
                                                    <?php if ($package_specification['item_type'] == 'default') {  $has_default=1;?>
                                                        <td width='500'>
                                                            <div class="checkbox">
                                                                <label>
                                                                    <input 
                                                                        data-extra-price="0.00" 
                                                                        data-item-type="<?= $package_specification['item_type'] ?>" 
                                                                        data-item-name="<?= $item_name ?>"
                                                                        data-group-id="<?= $package_specification['group_id'] ?>" 
                                                                        data-group-items="<?= $package_specification['group_items'] ?>" 
                                                                        type="checkbox" 
                                                                        class="items itemcheckbox group_<?= $package_specification['group_id'] ?>"
                                                                        id="item_<?= $package_specification['item_id'] ?>"
                                                                        data-cat-id="<?= $package_specification['category_id'] ?>" 
                                                                        data-cat-name="<?= $this->common_model->getSingleFieldFromAnyTable('pkg_cat_name', 'pkg_cat_id', $package_specification['category_id'], 'tbl_package_category') ?>" 
                                                                        name="package_items[]"
                                                                        value="<?= $package_specification['item_id'] ?>" 
                                                                        required
                                                                        > <?php echo $item_name; ?>
                                                                    <input type="hidden" value="<?php echo $package_detail['package_id'] ?>" name="package_id" >
                                                                    <input type="hidden" value="<?php echo $package_detail['name'] ?>" name="package_name" >

                                                                </label>
                                                            </div>      
                                                        </td>
                                                        <td width='530' colspan="4">
                                                            <input type="hidden" id="item_<?= $package_specification['item_id'] ?>_quantity" class="form-control" value="<?php echo $no_of_people ?>" disabled> 
                                                            <input type="hidden" name="package_item_quantity[]" class="quantity" value="<?php echo $no_of_people ?>" disabled>
                                                        </td>
                                                    <?php } else if ($package_specification['item_type'] == 'additional') { ?>
                                                        <td width='500'>
                                                            <div class="checkbox">
                                                                <label>
                                                                    <input 
                                                                        data-extra-price="<?= $package_specification['upgrade_price'] ?>" 
                                                                        data-item-type="<?= $package_specification['item_type'] ?>" 
                                                                        data-group-id="<?= $package_specification['group_id'] ?>" 
                                                                        data-group-items="<?= $package_specification['group_items'] ?>" 
                                                                        data-item-name="<?= $item_name ?>"
                                                                        type="checkbox" 
                                                                        class="items itemcheckbox group_<?= $package_specification['group_id'] ?>"
                                                                        id="item_<?= $package_specification['item_id'] ?>"
                                                                        data-cat-id="<?= $package_specification['category_id'] ?>" 
                                                                        data-cat-name="<?= $this->common_model->getSingleFieldFromAnyTable('pkg_cat_name', 'pkg_cat_id', $package_specification['category_id'], 'tbl_package_category') ?>" 
                                                                        name="package_items[]"
                                                                        value="<?= $package_specification['item_id'] ?>" 
                                                                        > <?php echo $item_name; ?>
                                                                    <input type="hidden" value="<?php echo $package_detail['package_id'] ?>" name="package_id" >
                                                                    <input type="hidden" value="<?php echo $package_detail['name'] ?>" name="package_name" >
                                                                </label>
                                                            </div>      
                                                        </td>
                                                        <?php //if ($package_specification['item_type'] == 'additional' && $package_specification['upgrade_price'] != 0 && $package_specification['upgrade_price'] != 0.00) {  ?>
                                                        <td width='530'>+$<?php echo $package_specification['upgrade_price'] ?> Per Head</td>
                                                        <?php //} ?>
                                                        <?php if ($package_specification['is_upgradable'] == 'yes') { ?>
                                                            <td width='200'>
                                                                
                                                                    
                                                                    <input type="text" id="item_<?= $package_specification['item_id'] ?>_quantity" class="form-control quantity" name="package_item_quantity[]" value="<?php echo $no_of_people ?>" disabled>
                                                                    
                                                                
                                                            </td>
                                                        <?php } else { ?>
                                                            <td width='200'><input type="text" id="item_<?= $package_specification['item_id'] ?>_quantity" class="form-control" value="<?php echo $no_of_people ?>" disabled> 
                                                                <input type="hidden" name="package_item_quantity[]" class="quantity" value="<?php echo $no_of_people ?>" disabled>
                                                            </td>
                                                        <?php } ?>
                                                        <?php //if ($package_specification['item_type'] == 'additional' && $package_specification['upgrade_price'] != 0 && $package_specification['upgrade_price'] != 0.00) {  ?>
                                                        <td width='100' id="item_<?= $package_specification['item_id'] ?>_price" class="item_price"><?php echo '$' . number_format($package_specification['upgrade_price'] * $no_of_people, 2, '.', '') ?></td>
                                                        <td width='100'><span class="label label-warning"><?= ($has_default==1)?'UPGRADED ITEM':'ADD ON' ?></span></td>
                                                        <?php //} ?>
                                                    <?php } ?>
                                                </tr>
                                            <?php } ?>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                        $char++;
                    }
                    ?>
                    <div class="price_form">
                        <input type="submit" name="submit" value="Add to Cart" class="btn btn-primary pull-right">
                    </div>
                </form>
            </div>
            <div class="col-md-3 sidebarCart">
                <?= $this->load->view($this->config->item('template') . '/sidebar_cart'); ?>
            </div>
        </div>
    </div>
</section>
<script src="<?= $this->config->item('frontassets') ?>js/catering.js"></script>
<script>
    $('body').delegate('.items', 'click', function () {
        var $this = $(this).parent().parent().parent().parent();
        var categorycheckedbox = $(this).parent().parent().parent().parent().parent().parent().find('input.items:checked').length;
        var totalcheckedbox = $('input.items:checked').length;
        var itemValue = $(this).val();
        var cat_id = $(this).attr('data-cat-id');
        var group_id = $(this).attr('data-group-id');
        var group_items = $(this).attr('data-group-items');
        var checkedItemsOfGroup = $('.group_' + group_id + ':checked').length;
        var item_type = $(this).attr('data-item-type');
        var cat_name = $(this).attr('data-cat-name');
        //  var item_quantity = $this.find('.quantity').val();
        if ($('#item_' + itemValue + '_quantity').is(':disabled')) {
            var item_quantity = $('#no_of_people').val();
        } else {
            var item_quantity = $('#item_' + itemValue + '_quantity').val();
        }
        var extra_price = parseFloat($(this).attr('data-extra-price') * item_quantity).toFixed(2);
        var item_name = $(this).attr('data-item-name');
        //    var packageCatLength = $('#package_items_tbody').find('#package_cat_tr_' + cat_id).length;
        // var packageNoItemsTrLength = $('#package_items_tbody').find('#no_items_tr').length;
//        if (packageNoItemsTrLength > 0) {
//            $('tbody#package_items_tbody').remove();
//            $('table#package_items_table').append('<thead id="package_items_thead"><th>Name</th><th>Type</th><th>Quantity</th><th>Cost</th></thead><tbody id="package_items_tbody"></tbody>');
//        }
//        if (packageCatLength == 0) {
//            $('tbody#package_items_tbody').append('<tr id="package_cat_tr_' + cat_id + '" class="active"><td colspan="4" style="text-align:left;">Category: ' + cat_name + '</td></tr>');
//        }
        if ($(this).is(':checked')) {
            // $('#package_items_tbody').append('<tr id="package_item_tr_' + itemValue + '"></tr>');
            $this.find('.qty_decrease').prop("disabled", false);
            $this.find('.qty_increase').prop("disabled", false);
            $this.find('.quantity').prop("disabled", false);

            if (checkedItemsOfGroup >= group_items) {
                if (item_type == 'default') {
                    $('.group_' + group_id).prop('required', false);
                }
                $('.group_' + group_id).prop("disabled", true);
                $('input.group_' + group_id + ':checked').prop("disabled", false);
            
            }
            $(this).prop("disabled", false);
            // addItemInTable(itemValue);
        } else {
//            if (categorycheckedbox < 1) {
//                $('#package_items_tbody tr#package_cat_tr_' + cat_id).remove();
//            }
//            if (totalcheckedbox < 1) {
//                $('#package_items_table thead#package_items_thead').remove();
//                $('#package_items_tbody').html('<tr id="no_items_tr"><td height="385" style="vertical-align: middle; text-align: center;">There is no item in your package currently.</td></tr>');
//            }
            //$('#package_items_tbody tr#package_item_tr_' + itemValue).remove();
            $this.find('.qty_decrease').prop("disabled", true);
            $this.find('.qty_increase').prop("disabled", true);
            $this.find('.quantity').prop("disabled", true);

            if (checkedItemsOfGroup < group_items) {
                $('.group_' + group_id).prop("disabled", false);
                if (item_type == 'default')
                    $('.group_' + group_id).prop('required', true);
            }
            // $(this).parent().parent().parent().parent().parent().parent().find('.group_' + group_id).prop('required', true);
            //  $(this).parent().parent().parent().parent().parent().parent().find('.group_' + group_id).prop("disabled", false);
        }
    });
    function addItemInTable(item_id) {
        var isDisabled = $('#item_' + item_id + '_quantity').prop('disabled');
        if (isDisabled) {
            var quantity = $('#no_of_people').val();
        } else {
            var quantity = $('#item_' + item_id + '_quantity').val();
        }
        // var quantity = $('#item_' + item_id + '_quantity').val();
        var total_price = parseFloat($('#item_' + item_id).attr('data-extra-price') * quantity).toFixed(2);
        $('#package_items_tbody tr#package_item_tr_' + item_id).remove();
        $('#package_items_tbody tr#package_cat_tr_' + $('#item_' + item_id).attr('data-cat-id')).after('<tr id="package_item_tr_' + item_id + '"><td>' + $('#item_' + item_id).attr('data-item-name') + '</td><td>' + $('#item_' + item_id).attr('data-item-type') + '</td><td>' + quantity + '</td><td>$' + total_price + '</td></tr>');
    }
    $("body").delegate(".qty_decrease", "click", function () {
        var quantity = $(this).parent().parent().find('.quantity').val();
        quantity = parseInt(quantity) - parseInt(1);
        var item_price = $(this).parent().parent().parent().parent().find('.items').attr('data-extra-price');
        var item_id = $(this).parent().parent().parent().parent().find('.items').val();
        if (!$(this).parent().parent().find('.quantity').prop('disabled') && quantity > 0) {
            $(this).parent().parent().find('.quantity').val(quantity);
            $(this).parent().parent().parent().parent().find('.item_price').text('$' + parseFloat(item_price * quantity).toFixed(2));
            addItemInTable(item_id);
        }
    });
    $("body").delegate(".qty_increase", "click", function () {
        var quantity = $(this).parent().parent().find('.quantity').val();
        quantity = parseInt(quantity) + parseInt(1);
        var item_price = $(this).parent().parent().parent().parent().find('.items').attr('data-extra-price');
        var item_id = $(this).parent().parent().parent().parent().find('.items').val();
        if (!$(this).parent().parent().find('.quantity').prop('disabled')) {
            $(this).parent().parent().find('.quantity').val(quantity);
            $(this).parent().parent().parent().parent().find('.item_price').text('$' + parseFloat(item_price * quantity).toFixed(2));
            addItemInTable(item_id);
        }
    });
</script>
<?php if ($this->session->flashdata('cart_coupon_messages')) { ?>
    <script>
        bootbox.alert("<?php echo $this->session->flashdata('cart_coupon_messages') ?>");
    </script>
<?php } ?>
<?php if ($this->session->flashdata('package_error')) { ?>
    <script>
        bootbox.alert("<?php echo $this->session->flashdata('package_error') ?>");
    </script>
<?php } ?>