<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1>Location Detail</h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li><a href="<?= site_url('location') ?>">Location</a></li>
            <li class="active"><?= $province_detail->province_name ?></li>
        </ol>
    </div>
</section>  
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <h2 class="section-heading"><?= $province_detail->province_name ?></h2>
        <div class="row">
            <div class="col-md-5">           
                <dl class="address_list">
                    <dt><i class="fa fa-map-marker"></i> Address :</dt>
                    <dd><?= $province_detail->address ?>  </dd>
                    <dt><i class="fa fa-phone"></i> Tel :</dt>
                    <dd><a href="tel:<?= $province_detail->telephone ?>"><?= $province_detail->telephone ?></a></dd>
                    <dt><i class="fa fa-envelope"></i> Email :</dt>
                    <dd><a href="mailto:<?= $province_detail->province_email_id ?>"><?= $province_detail->province_email_id ?></a></dd>
                    <dt><i class="fa fa-clock-o"></i> HOURS :</dt>
                    <dd><?= $province_detail->hours ?></dd>
                </dl>      
            </div>
            <div class="col-md-7">
                <iframe frameborder="0" class="location_map" src="<?= $province_detail->iframe_code ?>"></iframe>
                <hr>
                <?php if ($gallery_data) { ?>
                    <div class="row">
                        <?php foreach ($gallery_data as $gallery) { ?>
                            <div class="col-md-3">
                                <a href="<?= $this->config->item('uploads') ?>province_images/<?= $gallery['province_id'] ?>/<?= $gallery['image_name'] ?>" class="fancybox" data-fancybox-group="<?= $province_detail->province_name ?>">
                                    <img class="img-responsive thumbnail" src="<?= $this->config->item('uploads') ?>province_images/<?= $gallery['province_id'] ?>/<?= $gallery['image_name'] ?>"></a>
                            </div> 
                        <?php } ?> 
                    </div>
                    <a class="btn btn-default btn-block" href="<?= site_url() ?>gallery/<?= $province_detail->slug ?>">view our gallery</a>
                <?php } ?>
            </div>
        </div>
    </div>
</section>