<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>
            <?php
            $current_url = current_url();
            //echo $current_url;die;
            $meta_tags = $this->common_model->getMetaTitle($current_url);
            if ($meta_tags) {
                $METATITLE = $meta_tags['metatag_title'];
                $METAKEYWORDS = $meta_tags['metatag_keyword'];
                $METADESCRIPTION = $meta_tags['metatag_description'];
                $HEADERIMAGE = $meta_tags['banner_image'];
                $BACKGROUNDIMAGE = $meta_tags['background_image'];
            }
            if ($METATITLE) {
                echo $METATITLE;
            } else {
                echo $this->config->item('site_title');
            }
            ?></title>
        <?php if ($METAKEYWORDS) { ?>
            <meta name="keywords" content="<?php echo $METAKEYWORDS ?>" />
        <?php } else { ?>
            <meta name="keywords" content="<?php echo $this->config->item('meta_keywords'); ?>" />
        <?php } ?>
        <?php if ($METADESCRIPTION) { ?>
            <meta name="description" content="<?php echo $METADESCRIPTION ?>" />
        <?php } else { ?>
            <meta name="description" content="<?php echo $this->config->item('meta_description'); ?>" />
        <?php } ?>
        <link href="<?= $this->config->item('frontassets') ?>css/bootstrap.css" rel="stylesheet">
        <link href="<?= $this->config->item('frontassets') ?>css/font-awesome.min.css" rel="stylesheet">
        <link href="<?= $this->config->item('frontassets') ?>css/landing.css" rel="stylesheet">
        <!--[if lt IE 9]>
          <script src="js/html5shiv.min.js"></script>
          <script src="js/respond.min.js"></script>
        <![endif]-->
    </head>
    <body>
        <section class="welcome_Section landing_Section">
            <div class="container">
				<div class="top">
                <img class="logo" alt="A1Sweets" src="<?= $this->config->item('uploads') ?>site_images/<?= $this->config->item('logo') ?>">
                <h1>Welcome to our restaurant</h1>
                <p>Whatever your occasion, Our restaurant makes it one to remember! </p>
				</div>
                <div class="row loc">
                    <?php
                    $all_locations = $this->common_model->getAllLocation();
                    foreach ($all_locations as $locations) {
                        ?>
                        <div class="col-md-6 col-sm-6 text-center">
                            <a href="<?= site_url('change-location/' . $locations['province_id'] . '?redirect=' . base_url()) ?>">
							<div class="loc-box">
                                <div class="loc-icon"></div>                               
                                    <h2>
                                        <span class="serif"><?= $locations['province_name'] ?></span>
                                    </h2>
                                    <h4>Take-out & Catering</h4>                               
                            </div>
							</a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </section>
        <section class="topBar">
            <div class="container">
                <div class="copyright pull-left">
                    A1Sweets © <?php echo date('Y'); ?>
                </div>
                <div class="pull-right">                        
                    <?php if ($this->config->item('google')) { ?>
                        <a href="<?= $this->config->item('google') ?>" class="fa fa-google-plus">&nbsp;</a>
                    <?php } if ($this->config->item('twitter')) { ?> 
                        <a href="<?= $this->config->item('twitter') ?>" class="fa fa-twitter">&nbsp;</a>
                    <?php } if ($this->config->item('facebook')) { ?>
                        <a href="<?= $this->config->item('facebook') ?>" class="fa fa-facebook">&nbsp;</a>           
                    <?php } if ($this->config->item('pinterest')) { ?>
                        <a href="<?= $this->config->item('pinterest') ?>" class="fa fa-pinterest">&nbsp;</a>
                    <?php } if ($this->config->item('youtube')) { ?>
                        <a href="<?= $this->config->item('youtube') ?>" class="fa fa-youtube">&nbsp;</a>
                    <?php } ?>
                </div>
            </div>
        </section>
    </body>
</html>