<ul class="breadcrumb">
    <li><a href="<?= site_url('admin/dashboard') ?>">Home</a></li>
    <li class="active"><?php echo $breadcum ?></li> 
</ul>
<div class="page-content-wrap">                
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <?php if ($this->session->flashdata('ProvinceSuccess')) { ?>  
                    <div class="alert alert-success"> <?= $this->session->flashdata('ProvinceSuccess') ?></div>
                <?php } ?>
                <div class="panel-heading">
                    <h3 class="panel-title">Manage Province</h3>
                    <ul class="panel-controls" style="margin-top: 2px;">                                     
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown"><span class="fa fa-cog"></span></a>                                        
                            <ul class="dropdown-menu">
                                <li><a href="<?= base_url() ?>admin/province-add"><span class="fa fa-plus-square"></span>Add New</a></li>

                            </ul>                                        
                        </li>                                        
                    </ul>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>Country Name</th>                                    
                                    <th>Province Name</th> 
                                    <th>Default Location</th> 
                                    <th>Status</th>
                                    <th>Action</th>  
                                </tr>
                            </thead>
                            <tbody>   
                                <?php                             
                                    foreach ($province_data as $province) {
                                        ?>
                                        <tr id="trow">                                                
                                            <td><strong><?php echo (isset($province['country_name'])) ? $province['country_name'] : '-'; ?></strong></td>   
                                            <td><?php echo (isset($province['province_name'])) ? $province['province_name'] : '-'; ?></td> 
                                            <td><?php echo (isset($province['default_location'])) && $province['default_location'] == 'yes' ? "<span class='label label-info'>Yes" : "<span class='label label-primary'>No"; ?></td>
                                            <td><?php echo (isset($province['status'])) && $province['status'] == 'active' ? "<span class='label label-success'>Active" : "<span class='label label-danger'>Inactive"; ?></td>
                                            <td>
                                                <?php echo anchor(base_url() . 'admin/province-edit/' . $province['province_id'], '<span class="fa fa-pencil" title="Edit"></span>', 'class="btn btn-default btn-rounded btn-condensed btn-sm"'); ?>                                                       

                                                   <a class="btn btn-default btn-rounded btn-condensed btn-sm" href="<?= base_url() . 'admin/province-manage-pictures/'.$province['province_id'] ;?>" title="Manage Images"><span class="fa fa-upload"></span></a>          
                                                   
                                                <?php if ($province['status'] == 'active') { ?>
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/province-status/' . $province['province_id'] . '/inactive' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-ban" title="Inactive"></span></a>
                                                <?php } else { ?>    
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/province-status/' . $province['province_id'] . '/active' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-check-circle-o" title="Active"></span></a>
                                                <?php } ?>
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/province-delete/' . $province['province_id'] ?>" class="btn btn-danger btn-rounded btn-condensed btn-sm delete"><span class="fa fa-times" title="delete"></span></a>

                                                <?php if ($province['default_location'] == 'no') { ?> 
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/province-default-status/' . $province['province_id'] . '/yes' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm setDefaultLang"><span class="fa fa-folder-open" title="Set Default Language"></span></a>
                                                <?php } ?>
                                            </td> 
                                        </tr>  
                                <?php } ?>   
                            </tbody>
                        </table>
                    </div>                                

                </div>
            </div>                                                

        </div>
    </div>
</div>
<script>

    $('body').delegate('.setDefaultLang', 'click', function(evt) {
        var hrefUrl = $(this).attr('data-href');
        var box = $("#mb-setDefault-row");
        box.addClass("open");
        box.find(".mb-control-yes").on("click", function() {
            box.removeClass("open");
            window.location.href = hrefUrl;
        });
    });

</script>