<ul class="breadcrumb">
    <li><a href="<?= site_url('admin/dashboard') ?>">Home</a></li>
    <li class="active"><?php echo $breadcum; ?></li> 
</ul>
<div class="page-content-wrap">                
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <?php if ($this->session->userdata('pkg_success_msg')) { ?>  
                    <div class="alert alert-info"> <?= $this->session->userdata('pkg_success_msg') ?></div>
                    <?php
                    $this->session->unset_userdata('pkg_success_msg');
                }
                ?>
                <form action="" method="post" id="specification_form">
                    <div class="panel-heading">
                        <input type="submit" name="submit" value="Update" class="btn btn-default" />
                        <a href="javascript:" class="btn btn-default add_more"><span class="fa fa-plus-square"></span>Add New Row</a>
                    </div>
                    <div class="panel-body panel-body-table">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-actions">
                                <thead>
                                    <tr>  
                                        <th>Package Category</th>  
                                        <th>Package Item</th>  
                                        <th>Item Type</th>
                                        <th>Minimum People</th>
                                        <th>Upgrade Price</th>
                                        <th>Group Id</th>  
                                        <th>Group Items</th>  
                                        <th>Is Upgradable</th>  
                                        <th>Is Active</th>                                          
                                        <?php if ($specificationList) { ?>
                                            <th>Action</th> 
                                        <?php } ?>

                                    </tr>
                                </thead>
                                <tbody id="item_tbody"> 
                                    <?php
                                    $i = 0;
                                    foreach ($specificationList as $value) {
                                        $category_id = $value->category_id;
                                        $item_id = $value->item_id;
                                        ?>
                                        <tr class="item_tr">                                                                                      
                                            <td>
                                                <select class="form-control requiredField category_id" name="category_id[]" required>                                                    
                                                    <option value="">Select Package Category</option> 
                                                    <?php foreach ($package_category as $pkgCat) { ?>
                                                        <option value="<?= $pkgCat['pkg_cat_id'] ?>" <?php if ($pkgCat['pkg_cat_id'] == $category_id) { ?> selected="selected" <?php } ?>><?= $pkgCat['pkg_cat_name'] ?></option>
                                                    <?php } ?>                                                  
                                                </select>
                                            </td>  
                                            <td>
                                                <select class="form-control requiredField item" name="item_id[]" required>
                                                    <option value="">Select Package Item</option>
                                                    <?php foreach ($packg_item as $pkgItem) { ?> 
                                                        <option value="<?= $pkgItem['pkg_item_id'] ?>" <?php if ($pkgItem['pkg_item_id'] == $item_id) { ?> selected="selected" <?php } ?>><?= $pkgItem['item_name'] ?></option>
                                                    <?php } ?>
                                                </select>
                                            </td>  
                                            <td>
                                                <select class="form-control requiredField" name="item_type[]" required>
                                                    <option value="default" <?php if ($value->item_type != 'additional') { ?> selected="selected" <?php } ?>>Default</option>
                                                    <option value="additional" <?php if ($value->item_type == 'additional') { ?> selected="selected" <?php } ?>>Additional</option>                                                    
                                                </select>
                                            </td> 
                                            <td>
                                                <input type="text" name="min_people[]" value="<?= $value->min_people ?>" class="form-control requiredField" required/>
                                            </td>  
                                            <td>
                                                <input type="text" name="upgrade_price[]" value="<?= $value->upgrade_price ?>" class="form-control requiredField" required/>
                                            </td> 
                                            <td>
                                                <input type="text" name="group_id[]" value="<?= $value->group_id ?>" class="form-control requiredField" required/>
                                            </td> 
                                            <td>
                                                <input type="text" name="group_items[]" value="<?= $value->group_items ?>" class="form-control requiredField" required />
                                            </td> 
                                            <td>
                                                <select class="form-control requiredField" name="is_upgradable[]" required>
                                                    <option value="yes" <?php if ($value->is_upgradable == 'yes') { ?> selected="selected" <?php } ?>>yes</option>
                                                    <option value="no" <?php if ($value->is_upgradable != 'yes') { ?> selected="selected" <?php } ?>>No</option>
                                                </select>
                                            </td> 
                                            <td>
                                                <select class="form-control requiredField" name="is_active[]" required>
                                                    <option value="yes" <?php if ($value->is_active == 'yes') { ?> selected="selected" <?php } ?>>Yes</option>
                                                    <option value="no" <?php if ($value->is_active != 'yes') { ?> selected="selected" <?php } ?>>No</option>
                                                </select>
                                            </td> 
                                            <td>
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/package-specification-delete/' . $value->pkg_specification_id . '/' . $packageId ?>" class="btn btn-danger btn-rounded btn-condensed btn-sm delete"><span class="fa fa-times" title="delete"></span></a>
                                            </td> 
                                        </tr>
                                        <?php
                                        $i++;
                                    }
                                    ?>

                                    <?php if (sizeof($specificationList) == 0) { ?>
                                        <tr class="item_tr">  
                                            <td>
                                                <select class="form-control requiredField category_id" name="category_id[]" id="category_id">
                                                    <option value="">Select Package Category</option>  
                                                    <?php foreach ($package_category as $pkgCat) { ?>                                                            
                                                        <option value="<?= $pkgCat['pkg_cat_id'] ?>"><?= $pkgCat['pkg_cat_name'] ?></option>              
                                                    <?php } ?>
                                                </select>
                                            </td>  
                                            <td>
                                                <select class="form-control requiredField item" name="item_id[]" id="item">
                                                    <option value="">Select Category First</option>
                                                </select>
                                            </td>  
                                            <td>
                                                <select class="form-control requiredField" name="item_type[]">
                                                    <option value="default">Default</option>
                                                    <option value="additional">Additional</option>                                                
                                                </select>
                                            </td>  
                                            <td>
                                                <input type="text" name="min_people[]" class="form-control requiredField" />
                                            </td>  
                                            <td>
                                                <input type="text" name="upgrade_price[]" class="form-control requiredField" />
                                            </td> 
                                            <td>
                                                <input type="text" name="group_id[]" class="form-control requiredField" />
                                            </td> 
                                            <td>
                                                <input type="text" name="group_items[]" class="form-control requiredField" required />
                                            </td> 
                                            <td>
                                                <select class="form-control requiredField" name="is_upgradable[]">
                                                    <option value="yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </td>
                                            <td>
                                                <select class="form-control requiredField" name="is_active[]">
                                                    <option value="yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </td> 
                                        </tr>   
                                    <?php } ?> 
                                </tbody>
                            </table>
                        </div>                                
                    </div>
                </form>
            </div>                                                
        </div>
    </div>
</div>
<style>
    .error { color:red!important;}
</style>
<script>
    $('body').delegate('.add_more', 'click', function () {
        var totalsize = parseInt($('.item_tr').size());
        $("#item_tbody tr:first").clone().find('input[type=text]').val('').end().find('textarea').val('').end().appendTo("#item_tbody");

    });
    $('body').delegate('.remove', 'click', function () {
        if ($('.item_tr').size() > 1) {
            $(this).parent().parent().remove();
        }
    });
    $(document).ready(function () {
        $('form#specification_form').submit(function () {
            $('form#specification_form .error').remove();
            var hasError = false;
            $('.requiredField').each(function () {
                if ($.trim($(this).val()) == '') {
                    if ($(this).parent().parent().find('input[type=checkbox]').prop("checked") == true) {
                        var labelText = $(this).prev('label').text();
                        $(this).parent().append('<span class="error">Required!</span>');
                        hasError = true;
                    }
                } else if ($(this).hasClass('unit_price') || $(this).hasClass('quantity')) {

                    if (!$.isNumeric(($.trim($(this).val())))) {
                        var labelText = $(this).prev('label').text();
                        $(this).parent().append('<span class="error">Invalid</span>');
                        hasError = true;
                    }
                }
            });
            if (!hasError) {
                var formInput = $(this).serialize();
                $('#specification_form').submit();
            }
            return false;
        });
    });
    $('body').delegate('.category_id', 'change', function () {
        var category_id = $(this).val();
        var $this = $(this).parent().parent();
        if (category_id != '') {
            $.ajax({
                type: "POST",
                async: true,
                url: baseurl + "admin/ajax-package-item-list",
                data: {
                    "category_id": category_id
                },
                dataType: "json",
                success: function (data) {
                    $this.find('.item').html('');
                    if (data.success) {
                        $this.find('.item').html('<option value="">Select Package Item</option>');
                        $.each(data.package_item, function (key, value) {
                            $this.find('.item').append('<option value="' + value.pkg_item_id + '">' + value.item_name + '</option>');
                        });
                    } else {
                        $this.find('.item').html('<option value="">No Record Found</option>');
                    }
                }
            });
        }
    });
</script>