<ul class="breadcrumb">
    <li><a href="<?= site_url('admin/dashboard') ?>">Home</a></li>
    <li class="active"><?php echo $breadcum ?></li> 
</ul>
<div class="page-content-wrap">                
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <?php if ($this->session->flashdata('PackageSuccess')) { ?>  
                    <div class="alert alert-success"> <?= $this->session->flashdata('PackageSuccess') ?></div>
                <?php } ?>
                <div class="panel-heading">
                    <h3 class="panel-title">Manage Meals</h3>
                    <ul class="panel-controls" style="margin-top: 2px;">                                     
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown"><span class="fa fa-cog"></span></a>
                            <ul class="dropdown-menu">
                                <li><a href="<?= base_url() ?>admin/meal-add"><span class="fa fa-plus-square"></span>Add New</a></li>
                            </ul>                                        
                        </li>                                        
                    </ul>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>Meal Title</th>
                                    <th>Meal Price</th>                                  
                                    <th>Minimum Order Amount</th>                                  
                                    <th>Status</th>
                                    <th>Action</th> 
                                </tr>
                            </thead>
                            <tbody>   
                                <?php
                                foreach ($package_data as $package) {
                                    ?>
                                    <tr id="trow">
                                        <td><strong><?php echo (isset($package['name'])) ? $package['name'] : '-'; ?></strong></td>
                                        <td><?php echo (isset($package['price'])) ? $package['price'] : '-'; ?></td>
                                        <td><?php echo (isset($package['min_order_amount'])) ? $package['min_order_amount'] : '-'; ?></td>
                                        <td><?php echo (isset($package['status'])) && $package['status'] == 'active' ? "<span class='label label-success'>Active" : "<span class='label label-danger'>Inactive"; ?></td>
                                        <td>
                                            <?php echo anchor(base_url() . 'admin/meal-edit/' . $package['package_id'], '<span class="fa fa-pencil" title="Edit"></span>', 'class="btn btn-default btn-rounded btn-condensed btn-sm"'); ?>                                                       

                                            <?php if ($package['status'] == 'active') { ?>
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/meal-status/' . $package['package_id'] . '/inactive' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-ban" title="Inactive"></span></a>
                                            <?php } else { ?>    
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/meal-status/' . $package['package_id'] . '/active' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-check-circle-o" title="Active"></span></a>
                                            <?php } ?>
                                            <a href="javascript:" data-href="<?= base_url() . 'admin/meal-delete/' . $package['package_id'] ?>" class="btn btn-danger btn-rounded btn-condensed btn-sm delete"><span class="fa fa-times" title="delete"></span></a>
                                            
                                            <a href="<?= site_url('admin/meal-specification/' . $package['package_id']) ?>" class="btn btn-default btn-rounded btn-condensed btn-sm">Meal Specifications
                                            </a>
                                        </td> 
                                    </tr>    
                                    <?php }
                                ?>
                            </tbody>
                        </table>
                    </div>                                
                </div>
            </div>                                                
        </div>
    </div>
</div>

