<ul class="breadcrumb">
    <li><a href="<?= site_url('admin/dashboard') ?>">Home</a></li>
    <li class="active"><?php echo $breadcum ?></li> 
</ul>
<div class="page-content-wrap">                
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <?php if ($this->session->flashdata('HeaderLinkSuccess')) { ?>  
                    <div class="alert alert-success"> <?= $this->session->flashdata('HeaderLinkSuccess') ?></div>
                <?php } ?>
                <div class="panel-heading">
                    <h3 class="panel-title">Manage Header Link</h3>
                    <ul class="panel-controls" style="margin-top: 2px;">                                     
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown"><span class="fa fa-cog"></span></a>
                            <ul class="dropdown-menu">
                                <li><a href="<?= base_url() ?>admin/header-link-add"><span class="fa fa-plus-square"></span>Add New</a></li>
                            </ul>                                        
                        </li>                                        
                    </ul>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>Link Title</th>
                                    <th>Link URL</th>                                    
                                    <th>Header Order</th>   
                                    <th>Status</th>
                                    <th>Action</th>  
                                </tr>
                            </thead>
                            <tbody>   
                                <?php
                                foreach ($header_data as $header) {
                                    ?>
                                    <tr>
                                        <td><strong><?php echo (isset($header['link_title'])) ? $header['link_title'] : '-'; ?></strong></td>
                                        <td><?php echo (isset($header['link_url'])) ? $header['link_url'] : '-'; ?></td>
                                        <td><?php echo (isset($header['header_order'])) ? $header['header_order'] : '-'; ?></td>
                                        <td><?php echo (isset($header['status'])) && $header['status'] == 'active' ? "<span class='label label-success'>Active" : "<span class='label label-danger'>Inactive"; ?></td>
                                        <td>
                                            <?php echo anchor(base_url() . 'admin/header-link-edit/' . $header['header_link_id'], '<span class="fa fa-pencil" title="Edit"></span>', 'class="btn btn-default btn-rounded btn-condensed btn-sm"'); ?>                                                       
                                            <?php if ($header['status'] == 'active') { ?>
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/header-link-status/' . $header['header_link_id'] . '/inactive' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-ban" title="Inactive"></span></a>
                                            <?php } else { ?>    
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/header-link-status/' . $header['header_link_id'] . '/active' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-check-circle-o" title="Active"></span></a>
                                            <?php } ?>
                                            <a href="javascript:" data-href="<?= base_url() . 'admin/header-link-delete/' . $header['header_link_id'] ?>" class="btn btn-danger btn-rounded btn-condensed btn-sm delete"><span class="fa fa-times" title="delete"></span></a>
                                        </td> 
                                    </tr>   
                                <?php } ?>   
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>                                                
        </div>
    </div>
</div>
