<!DOCTYPE html>
<html lang="en">
    <head>        
        <!-- META SECTION -->
        <title><?= $this->config->item('sitename'); ?> | Admin Panel</title>            
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <link rel="icon" href="favicon.ico" type="image/x-icon" />
        <!-- END META SECTION -->
        <!-- CSS INCLUDE -->        
        <link rel="stylesheet" type="text/css" id="theme" href="<?= $this->config->item('adminassets') ?>css/theme-default.css"/>
        <link rel="stylesheet" type="text/css" id="theme" href="<?= $this->config->item('adminassets') ?>css/dropzone/dropzone.css"/>
        <link rel="stylesheet" type="text/css" id="theme" href="<?= $this->config->item('adminassets') ?>css/blueimp/blueimp-gallery.min.css"/>
        
        <script type="text/javascript" src="<?= $this->config->item('adminassets'); ?>js/plugins/jquery/jquery.min.js"></script>
        <script type="text/javascript" src="<?= $this->config->item('adminassets'); ?>js/plugins/jquery/jquery-ui.min.js"></script>
        <script type="text/javascript" src="<?= $this->config->item('adminassets'); ?>js/plugins/bootstrap/bootstrap.min.js"></script>      
        <script type="text/javascript" src="<?= $this->config->item('adminassets'); ?>js/plugins/datatables/jquery.dataTables.min.js"></script>  
        <!-- END PLUGINS -->
        <!-- THIS PAGE PLUGINS -->
        <script type="text/javascript" src="<?= $this->config->item('adminassets'); ?>js/plugins/owl/owl.carousel.min.js"></script>             
        <script type="text/javascript" src="<?= $this->config->item('adminassets'); ?>js/plugins.js"></script>      
        <script type="text/javascript" src="<?= $this->config->item('adminassets'); ?>js/actions.js"></script>   
        <!-- EOF CSS INCLUDE -->
        <script>
            var baseurl = '<?= base_url() ?>';
        </script>
    </head>
    <body>
        <!-- START PAGE CONTAINER -->
        <div class="page-container page-navigation-top page-navigation-top-custom">            
            <!-- PAGE CONTENT -->
            <div class="page-content">
                <!-- START PAGE CONTENT HEADER -->
                <div class="page-content-header">
                    <a href="<?= site_url('admin/dashboard') ?>" class="logo"></a>
                    <div class="pull-right">                        

                        <div class="contacts">
                            <?=
                            $adminData = $this->common_model->getSingleRowFromAnyTable('id', $this->session->userdata('admin_id'), 'tbl_admin');
                            $country_id = $adminData->country_id;
                            $province_id = $adminData->province_id;
                            $country_name = $this->common_model->getsingleRowFromAnyTable('ct_id', $country_id, 'tbl_country');
                            $province_name = $this->common_model->getsingleRowFromAnyTable('province_id', $province_id, 'tbl_province');
                            ?>
                            <a href="mailto:<?= $adminData->email ?>"><span class="fa fa-envelope"></span><?= $adminData->email ?></a>
                            <a href="tel:<?= $adminData->phone ?>"><span class="fa fa-phone"></span><?= $adminData->phone ?></a><br>
                            <?php if ($country_name->country_name != '') { ?>
                                <a href="#">Country : <?= $country_name->country_name ?></a>
                            <?php } if ($province_name->province_name != '') { ?>
                                <a href="#">Region : <?= $province_name->province_name ?></a>
<?php } ?>
                        </div>
                    </div>
                </div>
                <!-- END PAGE CONTENT HEADER -->

                <!-- START X-NAVIGATION VERTICAL -->
                <ul class="x-navigation x-navigation-horizontal">
                    <li class="xn-navigation-control">
                        <a href="#" class="x-navigation-control"></a>
                    </li>

<!--                    <li <?php if ($page_name == 'dashboard') { ?> class="active" <?php } ?>>
<a href="<?= base_url() ?>admin/dashboard"><span class="fa fa-desktop"></span> <span class="xn-text">Dashboard</span></a>                        
</li>                    -->
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-user"></span> <span class="xn-text">Admin</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/admin-list"> Manage Admin</a></li>
                            <li><a href="<?= base_url() ?>admin/admin-add"> Add Admin</a></li>
                            <li><a href="<?= base_url() ?>admin/adminlog-list">Manage Admin Log</a></li>
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-file-image-o"></span> <span class="xn-text">Banner</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/banner-list"> Manage Banner</a></li>
                            <li><a href="<?= base_url() ?>admin/banner-add"> Add Banner</a></li>                        
                            <li><a href="<?= base_url() ?>admin/promotional-banner-list"> Manage Promotional Banner</a></li>
                            <li><a href="<?= base_url() ?>admin/promotional-banner-add"> Add Promotional Banner</a></li>     
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-files-o"></span> <span class="xn-text">Menu Item</span></a>
                        <ul>                                             
                            <li><a href="<?= base_url() ?>admin/menu-item-list"> Manage Menu Item</a></li>
                            <li><a href="<?= base_url() ?>admin/menu-item-add"> Add Menu Item</a></li>                        
                            <li><a href="<?= base_url() ?>admin/menu-category-list"> Manage Menu Category</a></li>
                            <li><a href="<?= base_url() ?>admin/menu-category-add"> Add Menu Category</a></li>                        
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-files-o"></span> <span class="xn-text">Tray Item</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/tray-category-list">Category List</a></li>
                            <li><a href="<?= base_url() ?>admin/tray-category-add"> Add Category</a></li> 
                            <li><a href="<?= base_url() ?>admin/tray-item-list">Product List</a></li>
                            <li><a href="<?= base_url() ?>admin/tray-item-add"> Add Product</a></li>  
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-files-o"></span> <span class="xn-text">Online Order</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/online-category-list">Category List</a></li>
                            <li><a href="<?= base_url() ?>admin/online-category-add"> Add Category</a></li> 
                            <li><a href="<?= base_url() ?>admin/online-item-list">Product List</a></li>
                            <li><a href="<?= base_url() ?>admin/online-item-add"> Add Product</a></li>  
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-files-o"></span> <span class="xn-text">Packages</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/package-category-list">Packages Category List</a></li>
                            <li><a href="<?= base_url() ?>admin/package-item-list">Packages Itmes List</a></li>
                            <li><a href="<?= base_url() ?>admin/package-list">Packages List</a></li>
                            <li><a href="<?= base_url() ?>admin/meal-list">Meal List</a></li>
                      
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-columns"></span> <span class="xn-text">Content</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/content-list">Manage Content</a></li>   
                            <li><a href="<?= base_url() ?>admin/header-link-list"> Manage Header Links</a></li>  
<!--                            <li><a href="<?= base_url() ?>admin/footer-link-list"> Manage Footer Links</a></li>  -->
                            <li><a href="<?= base_url() ?>admin/meta-tag-list"> Manage Meta Tags</a></li>  
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-globe"></span> <span class="xn-text">Blog</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/blog-list"> Manage Blog</a></li>
                            <li><a href="<?= base_url() ?>admin/blog-add"> Add Blog</a></li>                        
                            <li><a href="<?= base_url() ?>admin/blog-category-list"> Manage Blog Category</a></li>                                       
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-globe"></span> <span class="xn-text">Location</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/country-list"> Manage Countries</a></li>                           
                            <li><a href="<?= base_url() ?>admin/province-list"> Manage Province</a></li>
                            <li><a href="<?= base_url() ?>admin/area-list"> Manage Delivery Charges</a></li>
                        </ul>
                    </li> 
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-file-image-o"></span> <span class="xn-text">Orders & Enquiries</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/order-list"> Manage Orders</a></li>  
                            <li><a href="<?= base_url() ?>admin/coupon-list">Manage Coupon</a></li>                     
                            <li><a href="<?= base_url() ?>admin/enquiry-list"> Manage Enquiry</a></li>  
<!--                            <li><a href="<?= base_url() ?>admin/newsletter-list">Manage Newsletter</a></li>-->
                        </ul>
                    </li>                
                    <li class="xn-openable">
                        <a href="#"><span class="fa fa-wrench"></span> <span class="xn-text">General Settings</span></a>
                        <ul>
                            <li><a href="<?= base_url() ?>admin/website-links">Manage Website Settings</a></li>  
                            <li><a href="<?= base_url() ?>admin/email-template-list">Manage Email Template</a></li> 
                            <li><a href="<?= base_url() ?>admin/testimonial-list">Manage Testimonial</a></li> 
                        </ul>
                    </li> 
                    <li class="xn-icon-button pull-right last">
                        <a href="#"><span class="fa fa-power-off"></span></a>
                        <ul class="xn-drop-left animated zoomIn">                                              
                            <li><a href="javascript:" class="mb-control" data-box="#mb-signout"><span class="fa fa-sign-out"></span> Sign Out</a></li>
                            <li><a href="<?= site_url('admin/change-password') ?>"><span class="fa fa-sign-out"></span> Change Password</a></li>
                        </ul>                        
                    </li> 
                </ul>