<ul class="breadcrumb">
    <li><a href="<?= site_url('admin/dashboard') ?>">Home</a></li>
    <li class="active"><?php echo $breadcum ?></li> 
</ul>
<div class="page-content-wrap">                
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <?php if ($this->session->flashdata('CouponSuccess')) { ?>  
                    <div class="alert alert-success"> <?= $this->session->flashdata('CouponSuccess') ?></div>
                <?php } ?>
                <div class="panel-heading">
                    <h3 class="panel-title">Manage Coupon</h3>
                    <ul class="panel-controls" style="margin-top: 2px;">                                     
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown"><span class="fa fa-cog"></span></a>
                            <ul class="dropdown-menu">
                                <li><a href="<?= base_url() ?>admin/coupon-add"><span class="fa fa-plus-square"></span>Add New</a></li>
                            </ul>                                        
                        </li>                                        
                    </ul>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>Coupon Code</th>
                                    <th>Coupon Price</th>                                          
                                    <th>Coupon Type</th>                                          
                                    <th>Expiration Date</th>                                             
                                    <th>Country</th>
                                    <th>Province</th>
                                    <th>Status</th>
                                    <th>Action</th> 
                                </tr>
                            </thead>
                            <tbody>   
                                <?php                              
                                    foreach ($coupon_data as $coupon) {
                                        ?>
                                        <tr id="trow">
                                            <td><strong><?php echo (isset($coupon['coupon_code'])) ? $coupon['coupon_code'] : '-'; ?></strong></td>                                                  
                                            <td><?php echo (isset($coupon['coupon_price'])) ? $coupon['coupon_price'] : '-'; ?></td>
                                            <td><?php echo (isset($coupon['coupon_type'])) && $coupon['coupon_type'] == 'percentage' ? "<span class='label label-info'>Percentage" : "<span class='label label-primary'>Money"; ?></td>
                                            <td><?php echo (isset($coupon['expiration_date'])) ? date('m/d/Y', $coupon['expiration_date']) : '-'; ?></td> 
                                            <td><?php echo (isset($coupon['country_name'])) ? $coupon['country_name'] : '-'; ?></td>
                                            <td><?php echo (isset($coupon['province_name'])) ? $coupon['province_name'] : '-'; ?></td>
                                            <td><?php echo (isset($coupon['status'])) && $coupon['status'] == 'active' ? "<span class='label label-success'>Active" : "<span class='label label-danger'>Inactive"; ?></td>
                                            <td>
                                                <?php echo anchor(base_url() . 'admin/coupon-edit/' . $coupon['coupon_id'], '<span class="fa fa-pencil" title="Edit"></span>', 'class="btn btn-default btn-rounded btn-condensed btn-sm"'); ?>                                                       

                                                <?php if ($coupon['status'] == 'active') { ?>
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/coupon-status/' . $coupon['coupon_id'] . '/inactive' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-ban" title="Inactive"></span></a>
                                                <?php } else { ?>    
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/coupon-status/' . $coupon['coupon_id'] . '/active' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-check-circle-o" title="Active"></span></a>
                                                <?php } ?>
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/coupon-delete/' . $coupon['coupon_id'] ?>" class="btn btn-danger btn-rounded btn-condensed btn-sm delete"><span class="fa fa-times" title="delete"></span></a>

                                            </td> 
                                        </tr>   
                                <?php } ?>   
                            </tbody>
                        </table>
                    </div>                                

                </div>
            </div>                                                

        </div>
    </div>
</div>
