<ul class="breadcrumb">
    <li><a href="<?= site_url('admin/dashboard') ?>">Home</a></li>
    <li class="active"><?php echo $breadcum ?></li> 
</ul>
<div class="page-content-wrap">                
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <?php if ($this->session->flashdata('CountrySuccess')) { ?>  
                    <div class="alert alert-success"> <?= $this->session->flashdata('CountrySuccess') ?></div>
                <?php } ?>
                <div class="panel-heading">
                    <h3 class="panel-title">Manage Country</h3>
                    <ul class="panel-controls" style="margin-top: 2px;">                                     
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown"><span class="fa fa-cog"></span></a>                                        
                            <ul class="dropdown-menu">
                                <li><a href="<?= base_url() ?>admin/country-add"><span class="fa fa-plus-square"></span>Add New</a></li>

                            </ul>                                        
                        </li>                                        
                    </ul>
                </div>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>Country Code</th>                                    
                                    <th>Country Name</th>
                                    <th>Currency Name</th>
                                    <th>Country Image</th>                                   
                                    <th>Status</th>
                                    <th>Action</th>  
                                </tr>
                            </thead>
                            <tbody>   
                                <?php                           
                                    foreach ($country_data as $country) {
                                        ?>
                                        <tr id="trow">
                                            <td><strong><?php echo (isset($country['code'])) ? $country['code'] : '-'; ?></strong></td>
                                            <td><?php echo (isset($country['country_name'])) ? $country['country_name'] : '-'; ?></td>                                                     
                                            <td><?php echo (isset($country['currency_name'])) ? $country['currency_name'] : '-'; ?></td>                                                     
                                            <td><img src="<?= base_url() ?>assets/uploads/country_images/<?php echo (isset($country['image'])) ? $country['image'] : ''; ?>"></td>  
                                            <td><?php echo (isset($country['status'])) && $country['status'] == 'active' ? "<span class='label label-success'>Active" : "<span class='label label-danger'>Inactive"; ?></td>
                                            <td>
                                                <?php echo anchor(base_url() . 'admin/country-edit/' . $country['ct_id'], '<span class="fa fa-pencil" title="Edit"></span>', 'class="btn btn-default btn-rounded btn-condensed btn-sm"'); ?>                                                       

                                                <?php if ($country['status'] == 'active') { ?>
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/country-status/' . $country['ct_id'] . '/inactive' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-ban" title="Inactive"></span></a>
                                                <?php } else { ?>    
                                                    <a href="javascript:" data-href="<?= base_url() . 'admin/country-status/' . $country['ct_id'] . '/active' ?>" class="btn btn-default btn-rounded btn-condensed btn-sm changestatus"><span class="fa fa-check-circle-o" title="Active"></span></a>
                                                <?php } ?>
                                                <a href="javascript:" data-href="<?= base_url() . 'admin/country-delete/' . $country['ct_id'] ?>" class="btn btn-danger btn-rounded btn-condensed btn-sm delete"><span class="fa fa-times" title="delete"></span></a>

                                            </td> 
                                        </tr>    
                                <?php } ?>   
                            </tbody>
                        </table>
                    </div>                                

                </div>
            </div>                                                

        </div>
    </div>
</div>
