<?php

class Province_Model extends CI_Model {

    var $tableName = 'tbl_province';
    var $tableImagesName = 'tbl_province_images';

    function getAllProvince() {
        $this->db->select('*');
        $this->db->from($this->tableName);
        $this->db->where('status', 'active');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function getProvinceBySlug($slug) {
        $this->db->select('*');
        $this->db->from($this->tableName);
        $this->db->where('slug', $slug);
        $this->db->where('status', 'active');
        $query = $this->db->get();
        $result = $query->row();
        return $result;
    }

    function getProvinceById($province_id) {
        $this->db->select('*');
        $this->db->from($this->tableName);
        $this->db->where('province_id', $province_id);
        //$this->db->where('status', 'active');
        $query = $this->db->get();
        $result = $query->row();
        return $result;
    }

    function generate_session($slug) {
        $province_id = $this->common_model->getSingleFieldFromAnyTable('province_id', 'slug', $slug, 'tbl_province');
        $this->session->set_userdata('location_id', $province_id);
        return true;
    }

    function get_gallery_by_province($province_id = '', $limit = '') {
        if ($province_id != '')
            $this->db->where('province_id', $province_id);
        if ($limit != '')
            $this->db->limit($limit);
        $query = $this->db->get($this->tableImagesName);
        $result = $query->result_array();
        return $result;
    }

}

?>
