<?php

class Order_Model extends CI_Model {

    var $tablename = 'tbl_order';
    var $tableOrderItem = 'tbl_order_items';
    var $tableOrderPackageItem = 'tbl_order_pkg_items';

    public function addConfirmedOrder($cart_data) {
        $customerDetail = $this->session->userdata($this->session->userdata('my_session_id'));
        $this->db->set('sub_total', $cart_data['sub_total']);
        $this->db->set('gst', $cart_data['gst']);
        $this->db->set('pst', $cart_data['pst']);
        $this->db->set('hst', $cart_data['hst']);
        $this->db->set('gst_per', $cart_data['gst_per']);
        $this->db->set('pst_per', $cart_data['pst_per']);
        $this->db->set('hst_per', $cart_data['hst_per']);
        $this->db->set('discount', $cart_data['discount']);
        $this->db->set('coupon_id', $cart_data['coupon_id']);
        $this->db->set('coupon_code', $cart_data['coupon_code']);
        $this->db->set('coupon_percentage', $cart_data['coupon_percentage']);
        $this->db->set('total_amount', $cart_data['total_cart_price']);
        $this->db->set('name', $customerDetail['name']);
        $this->db->set('phone', $customerDetail['phone']);
        $this->db->set('email', $customerDetail['email']);
        $this->db->set('address', $customerDetail['address']);
        $this->db->set('city', $customerDetail['city']);
//          if ($customerDetail['address2'])
//        $this->db->set('address2', $customerDetail['address2']);
        if ($customerDetail['payment_type'])
            $this->db->set('payment_type', $customerDetail['payment_type']);
        else
            $this->db->set('payment_type', 'cash_on_delivery');
        if($customerDetail['delivery_type']=='pickup') {
             $this->db->set('delivery_charges', 0);
                $this->db->set('area_name', '');
                $this->db->set('area_id', 0);
                if($cart_data['delivery_charges']=='')
                    $cart_data['delivery_charges']=0;
                $this->db->set('total_amount', $cart_data['total_cart_price']-$cart_data['delivery_charges']);
                 $this->db->set('delivery_type', 'pickup');
        } else  {
        if ($customerDetail['area_id'] != '' && $customerDetail['area_id'] != '0') {
            if ($customerDetail['area_id'] == $cart_data['area_id']) {
                $this->db->set('delivery_charges', $cart_data['delivery_charges']);
                $this->db->set('area_name', $cart_data['area_name']);
                $this->db->set('area_id', $cart_data['area_id']);
                $this->db->set('total_amount', $cart_data['total_cart_price']);
            } else {
                $this->db->set('area_id', $customerDetail['area_id']);
                $area_detail = $this->common_model->getSingleRowFromAnyTable('area_id', $customerDetail['area_id'], 'tbl_area_wise_delivery_charges');
                $this->db->set('delivery_charges', $area_detail->charges);
                $this->db->set('area_name', $area_detail->area_name);
                $this->db->set('total_amount', $cart_data['total_cart_price'] + $area_detail->charges);
            }
            $this->db->set('delivery_type', 'delivery');
        } else {
            $this->db->set('delivery_type', 'pickup');
        }
        }
        $this->db->set('delivery_time', strtotime($customerDetail['delivery_time']));
        $this->db->set('delivery_date', strtotime($customerDetail['delivery_date']));
        $this->db->set('location_id', $this->session->userdata('location_id'));
        $this->db->set('location_name', $this->common_model->getSingleFieldFromAnyTable('province_name', 'province_id', $this->session->userdata('location_id'), 'tbl_province'));
        if ($customerDetail['delivery_location_id'] != '') {
            $this->db->set('delivery_location_id', $customerDetail['delivery_location_id']);
            $this->db->set('delivery_location_name', $this->common_model->getSingleFieldFromAnyTable('province_name', 'province_id', $customerDetail['delivery_location_id'], 'tbl_province'));
        } else {
            $this->db->set('delivery_location_id', $this->session->userdata('location_id'));
            $this->db->set('delivery_location_name', $this->common_model->getSingleFieldFromAnyTable('province_name', 'province_id', $this->session->userdata('location_id'), 'tbl_province'));
        }
        $this->db->set('comments', $customerDetail['comments']);
        $this->db->set('add_time', time());
        $this->db->insert($this->tablename);
        return $this->db->insert_id();
    }

    public function updateOrderPaymentStatus($payment_data) {
        if ($payment_data['payment_status'])
            $this->db->set('payment_status', $payment_data['payment_status']);
        $this->db->set('order_status', $payment_data['order_status']);
        if ($payment_data['transaction_id'])
            $this->db->set('transaction_id', $payment_data['transaction_id']);
        $this->db->set('other_data', $payment_data['other_data']);
        $this->db->where('order_id', $payment_data['order_id']);
        $response = $this->db->update($this->tablename);
        return $response;
    }

    public function addOrderItems($order_id, $cart_items) {
        $this->db->set('order_id', $order_id);
        $this->db->set('item_id', $cart_items['item_id']);
        $this->db->set('item_name', $cart_items['item_name']);
        $this->db->set('category_id', $cart_items['category_id']);
        $this->db->set('category_name', $cart_items['category_name']);
        $this->db->set('unit_price', $cart_items['unit_price']);
        $this->db->set('unit_id', $cart_items['unit_id']);
        $this->db->set('unit_name', $cart_items['unit_name']);
        $this->db->set('no_of_people', $cart_items['no_of_people']);
        $this->db->set('item_type', $cart_items['item_type']);
        $this->db->set('item_quantity', $cart_items['item_quantity']);
        $this->db->set('total_item_price', $cart_items['total_item_price']);
        $this->db->insert($this->tableOrderItem);
        return $this->db->insert_id();
    }

    function addOrderPackageItems($order_item_id, $cart_package_items) {
        foreach ($cart_package_items as $cart_package_item) {
            $this->db->set('order_item_id', $order_item_id);
            $this->db->set('item_id', $cart_package_item['item_id']);
            $this->db->set('item_name', $cart_package_item['item_name']);
            $this->db->set('category_id', $cart_package_item['category_id']);
            $this->db->set('category_name', $cart_package_item['category_name']);
            $this->db->set('item_price', $cart_package_item['item_price']);
            $this->db->set('item_type', $cart_package_item['item_type']);
            $this->db->set('item_quantity', $cart_package_item['item_quantity']);
            $this->db->set('total_item_price', $cart_package_item['total_item_price']);
            $this->db->insert($this->tableOrderPackageItem);
        }
    }

    function orderDetailById($order_id) {
        $this->db->where('order_id', $order_id);
        $query = $this->db->get($this->tablename);
        $result = $query->row_array();
        return $result;
    }

    function getOrderItems($order_id) {
        $this->db->where('order_id', $order_id);
        $query = $this->db->get($this->tableOrderItem);
        $result = $query->result_array();
        return $result;
    }

    function getOrderPackageItems($order_item_id) {
        $this->db->where('order_item_id', $order_item_id);
        $query = $this->db->get($this->tableOrderPackageItem);
        $result = $query->result_array();
        return $result;
    }

}
