<?php

class Online_Item_Model extends CI_Model {

    var $tableName = 'tbl_online_item';
    var $tableOnlineUnits = 'tbl_online_units';

    public function getOnlineItemByCatId($cat_id) {
        $this->db->where($this->tableName . '.status', 'active');
        $this->db->where($this->tableName . '.category_id', $cat_id);
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

//    public function getOnlineItemByCatId($cat_id,$per_page,$currentpage) {
//        $this->db->where($this->tableName . '.status', 'active');       
//        $where = "FIND_IN_SET('".$cat_id."', tbl_online_item.category_id)";  
//        $this->db->where( $where );    
//        $query = $this->db->get($this->tableName,$per_page,$currentpage);
//        $result = $query->result_array();  
//     // echo  $this->db->last_query();die;
//        return $result;
//    }
    public function getCountOnlineItemByCatId($cat_id) {
        $this->db->where($this->tableName . '.status', 'active');
        $where = "FIND_IN_SET('" . $cat_id . "', tbl_online_item.category_id)";
        $this->db->where($where);
        $query = $this->db->get($this->tableName);
        $result = $query->num_rows();
        return $result;
    }

    public function getOnlineItemByItemId($online_item_id) {
        // $this->db->where($this->tableName . '.status', 'active');       
        $this->db->where($this->tableName . '.online_item_id', $online_item_id);
        //  $where = "FIND_IN_SET('".$cat_id."', tbl_online_item.category_id)";   
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        // echo  $this->db->last_query();die;
        return $result;
    }

    public function getOnlineItemByMatrixAndId($online_item_id, $matrix_id) {
        $this->db->where($this->tableName . '.status', 'active');
        $where = "FIND_IN_SET('" . $matrix_id . "', tbl_online_item.online_matrix)";
        $this->db->where($where);
        $this->db->where($this->tableName . '.online_item_id', $online_item_id);
        //  $where = "FIND_IN_SET('".$cat_id."', tbl_online_item.category_id)";   
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        // echo  $this->db->last_query();die;
        return $result;
    }

    public function getAllOnlineItems() {
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    public function getUnitsByOnlineItemId($onlineItemId) {
        $this->db->where($this->tableOnlineUnits . '.is_active', 'yes');
        $this->db->where($this->tableOnlineUnits . '.online_item_id', $onlineItemId);
        $query = $this->db->get($this->tableOnlineUnits);
        $result = $query->result();
        return $result;
    }

    public function getUnitPricesById($unit_id) {
        //$this->db->select($this->tableOnlineUnits.'unit_prices');
        $this->db->where($this->tableOnlineUnits . '.is_active', 'yes');
        $this->db->where($this->tableOnlineUnits . '.unit_id', $unit_id);
        $query = $this->db->get($this->tableOnlineUnits);
        $result = $query->row();
        return $result;
    }

}
