<?php

class Common_Model extends CI_Model {

    public function __construct() {
        global $URI, $CFG, $IN;
        $ci = get_instance();
        $ci->load->config('config');
        $websiteData = $this->website_list();
        $ci->config->set_item('facebook', $websiteData->facebook);
        $ci->config->set_item('twitter', $websiteData->twitter);
        $ci->config->set_item('youtube', $websiteData->youtube);
        $ci->config->set_item('google', $websiteData->google);
        $ci->config->set_item('linkedin', $websiteData->linkedin);
        $ci->config->set_item('site_email', $websiteData->site_email);
        $ci->config->set_item('paypal_email', $websiteData->paypal_email);
        $ci->config->set_item('meta_keywords', $websiteData->meta_keywords);
        $ci->config->set_item('meta_description', $websiteData->meta_description);
        $ci->config->set_item('minimum_order_amount', $websiteData->minimum_order_amount);
        $ci->config->set_item('delivery_charges', $websiteData->delivery_charges);
        $ci->config->set_item('delivery_note', $websiteData->delivery_note);
        $ci->config->set_item('logo', $websiteData->logo);
        $ci->config->set_item('site_title', $websiteData->site_title);
        $ci->config->set_item('contact_no', $websiteData->contact_no);
        $ci->config->set_item('contact_address', $websiteData->contact_address);
        $ci->config->set_item('gogole_code', $websiteData->gogole_code);
        $ci->config->set_item('google_analytic_code', $websiteData->google_analytic_code);
        $ci->config->set_item('site_email', $websiteData->site_email);
        $ci->config->set_item('page_size_front', $websiteData->page_size_front);
        if (!$this->session->userdata('my_session_id')) {
            $uniqueId = uniqid($this->input->ip_address(), TRUE);
            $this->session->set_userdata("my_session_id", md5($uniqueId));
        }
        if (!$this->session->userdata('location_id')) {
           // $this->setLocation();
        }
        if ($this->session->userdata('location_id')) {
            $provinceDetail = $this->setTax();
            $ci->config->set_item('gst', $provinceDetail->gst);
            $ci->config->set_item('pst', $provinceDetail->pst);
            $ci->config->set_item('hst', $provinceDetail->hst);
            $ci->config->set_item('currency_name', $provinceDetail->currency_name);
            $ci->config->set_item('google_link', $provinceDetail->google_link);
            $ci->config->set_item('province_email_id', $provinceDetail->province_email_id);
            $ci->config->set_item('province_address', $provinceDetail->address);
            $ci->config->set_item('copyright_text', $provinceDetail->copyright_text);
            $ci->config->set_item('province_telephone', $provinceDetail->telephone);
            $ci->config->set_item('location_id', $provinceDetail->province_id);
            $ci->config->set_item('location_name', $provinceDetail->province_name);
        }
    }

    function setTax() {
        $this->db->select('tbl_province.*,tbl_country.currency_name');
        $this->db->where('province_id', $this->session->userdata('location_id'));
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_province.country_id', 'left');
        $query = $this->db->get('tbl_province');
        return $query->row();
    }

    function setLocation() {

        $ips = file_get_contents('http://api.ipinfodb.com/v3/ip-city/?key=%2074a8abe159639e76358420bf4a67b54bc7370bd9bf19d4944b06f122fcaed8b2&ip=' . $_SERVER['REMOTE_ADDR'] . '&format=json');
        $datas = json_decode($ips);

        $this->db->select('tbl_province.province_id,tbl_country.code');
        $this->db->where('LOWER(tbl_province.province_name)', strtolower($datas->provinceName));
        $this->db->where('LOWER(tbl_country.code)', strtolower($datas->countryCode));
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_province.country_id', 'left');
        $query = $this->db->get('tbl_province');
        $data = $query->row();
        $location_id = $data->province_id;
        if ($location_id) {
            $this->session->set_userdata('location_id', $location_id);
        } 
//        else {
//            $this->db->select('tbl_province.province_id');
//            $this->db->where('tbl_province.default_location', 'yes');
//            $query = $this->db->get('tbl_province');
//            $data = $query->row();
//            $location_id = $data->province_id;
//            if ($location_id)
//                $this->session->set_userdata('location_id', $location_id);
//        }
    }

    #=============Function Create Unique Slug===========================================================#

    function create_unique_slug_for_common($app_title, $table) {
        $slug = url_title($app_title);
        $slug = strtolower($slug);
        $i = 0;
        $params = array();
        $params['slug'] = $slug;
        while ($this->db->where($params)->get($table)->num_rows()) {
            if (!preg_match('/-{1}[0-9]+$/', $slug)) {
                $slug .= '-' . ++$i;
            } else {
                $slug = preg_replace('/[0-9]+$/', ++$i, $slug);
            }
            $params ['slug'] = $slug;
        }
        $app_title = $slug;
        return $app_title;
    }

    function getSingleFieldFromAnyTable($field_name, $condition_coloum, $condition_value, $table_name) {
        $this->db->select($field_name);
        $this->db->where($condition_coloum, $condition_value);
        $query = $this->db->get($table_name);
        $data = $query->row();
        return $data->$field_name;
    }

    function getSingleRowFromAnyTable($condition_coloum, $condition_value, $table_name) {
        $this->db->select($field_name);
        $this->db->where($condition_coloum, $condition_value);
        $query = $this->db->get($table_name);
        $data = $query->row();
        return $data;
    }

    function getCountAllFromAnyTable($condition_coloum, $condition_value, $table_name, $status) {
        $this->db->where($condition_coloum, $condition_value);
        if ($status)
            $this->db->where('status', $status);
        $query = $this->db->get($table_name);
        $nums = $query->num_rows();
        return $nums;
    }

    function getFieldsFromAnyTable($condition_coloum, $condition_value, $table_name, $order_coloum, $status) {
        $this->db->where($condition_coloum, $condition_value);
        if ($status)
            $this->db->where('status', $status);
        if ($order_coloum)
            $this->db->order_by($order_coloum, 'asc');
        $query = $this->db->get($table_name);
        $data = $query->result();
        return $data;
    }

    function getFieldsFromAnyTableTwoCondtion($condition_coloum1, $condition_value1, $condition_coloum2, $condition_value2, $table_name, $order_coloum, $order_by, $status, $limit, $group_by) {
        $this->db->where($condition_coloum1, $condition_value1);
        if ($condition_coloum2)
            $this->db->where($condition_coloum2, $condition_value2);
        if ($status)
            $this->db->where('status', $status);
        if ($limit)
            $this->db->limit($limit);
        if ($order_coloum)
            $this->db->order_by($order_coloum, $order_by);
        if ($group_by)
            $this->db->group_by($group_by);
        $query = $this->db->get($table_name);
        $data = $query->result();
        return $data;
    }

    function checkAdminLogin() {
        if ($this->session->userdata('admin_id') == '') {
            redirect('admin/login');
            exit;
        }
    }

    function checkUserLocation() {
        if (!$this->session->userdata('location_id')) {
            redirect('select-your-location');
            exit;
        }
    }

    function checkCartItems() {
        if ($this->countCartItems() <= 0) {
            redirect('online-order');
            exit;
        }
    }

    function website_list($id = '') {
        $this->db->select('*');
        $this->db->from('tbl_website_settings');
        if ($id != '')
            $this->db->where('tbl_website_settings.id', $id);
        $query = $this->db->get();
        $result = $query->row();
        return $result;
    }

    function curPageURL() {
        $pageURL = 'http';
        if ($_SERVER["HTTPS"] == "on") {
            $pageURL .= "s";
        }
        $pageURL .= "://";
        if ($_SERVER["SERVER_PORT"] != "80") {
            $pageURL .= $_SERVER["SERVER_NAME"] . ":" . $_SERVER["SERVER_PORT"] . $_SERVER["REQUEST_URI"];
        } else {
            $pageURL .= $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
        }
        return $pageURL;
    }

    function showLimitedText($string, $len) {
        $string = strip_tags($string);
        if (strlen($string) > $len)
            $string = substr($string, 0, $len - 3) . "...";
        return $string;
    }

    function getAllLocation() {
        $this->db->select('*');
        $this->db->from('tbl_province');
        $this->db->where('status', 'active');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function getBannerImages() {
        $query = $this->db->get('tbl_banner');
        $result = $query->result_array();
        return $result;
    }

    function getAdminRecords() {
        $this->db->where('username', $this->session->userdata('admin_user_name'));
        $query = $this->db->get('tbl_admin');
        $result = $query->result_array();
        return $result;
    }

    function getLoggedInAdminRecords() {
        $this->db->where('id', $this->session->userdata('admin_id'));
        $query = $this->db->get('tbl_admin');
        $result = $query->row_array();
        return $result;
    }

    function getBlogRecords() {
        $this->db->order_by('tbl_blog.add_time', 'desc');
        $this->db->limit(2);
        $query = $this->db->get('tbl_blog');
        $result = $query->result_array();
        return $result;
    }

    function getCategoryLevel($cat_id) {
        for ($i = 1; $i <= 10; $i++) {

            $this->db->select('parent_id');
            $this->db->where('tray_cat_id', $cat_id);
            $query = $this->db->get('tbl_tray_category');
            $result = $query->row();

            if ($result->parent_id == 0) {
                return $i;
            } else {
                $cat_id = $result->parent_id;
            }
        }
    }

    function getHeaderLinks() {
        $this->db->select('*');
        $this->db->from('tbl_header_links');
        $this->db->where('tbl_header_links.status', 'active');
        $this->db->order_by('tbl_header_links.header_order', 'asc');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function getMetaTitle($current_url) {
        $this->db->select('*');
        $this->db->from('tbl_metatag');
        $this->db->where('tbl_metatag.status', 'active');
        $this->db->where('tbl_metatag.metatag_url', $current_url);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }

    public function countCartItems() {
        $this->db->where('session_id', $this->session->userdata('my_session_id'));
        $query = $this->db->get('tbl_cart_items');
        $result = $query->num_rows();
        return $result;
    }

    function getSidebarImages() {
        $this->db->where('status', 'active');
        $query = $this->db->get('tbl_side_banners');
        $result = $query->result_array();
        return $result;
    }

}
