<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sidebanner_model extends CI_Model {

    var $tableName = 'tbl_side_banners';

    
    function getSidebannerList() {
        $this->db->select($this->tableName . '.*,tbl_country.country_name,tbl_province.province_name');
        $this->db->from($this->tableName);
        $location_id = $this->session->userdata('admin_location_id');
        if($location_id!='0'){
        $this->db->where($this->tableName .'.province_id',$location_id);
        }
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_side_banners.country_id');
        $this->db->join('tbl_province', 'tbl_province.province_id=tbl_side_banners.province_id');   
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function getSidebarBannerListById($bannerId) {
        if ($bannerId != '')
            $this->db->where($this->tableName . '.sidebanner_id', $bannerId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function add($sidebanner_image) {

        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));
        if ($this->input->post('sidebanner_link'))
            $this->db->set('sidebanner_link', $this->input->post('sidebanner_link'));
        if ($sidebanner_image)
            $this->db->set('sidebanner_image', $sidebanner_image);

        $this->db->set('status', 'active');
        $this->db->set('add_time', time());

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function updateSlug($bannerId, $sidebanner_image) {
        if ($sidebanner_image)
            $this->db->set('sidebanner_image', $sidebanner_image);

        if ($this->input->post('sidebanner_link'))
            $this->db->set('sidebanner_link', $this->input->post('sidebanner_link'));
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));     

        $this->db->where('sidebanner_id', $bannerId);
        $query = $this->db->update($this->tableName);
        return $response;
    }
    
    public function updateStatus($bannerId, $status) {
        $this->db->set('status', $status);
        $this->db->where('sidebanner_id', $bannerId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($bannerId) {
        $this->db->where('sidebanner_id', $bannerId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }


}