<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package_Model extends CI_Model {

    var $tableName = 'tbl_packages';
    var $tablePkgSpecification = 'tbl_pkg_specification';
    var $tablePkgCat = 'tbl_package_category';
    var $tablePkgItems = 'tbl_package_items';

    function getPackageList($package_type='package') {
        $this->db->select($this->tableName . '.*,tbl_country.country_name,tbl_province.province_name');
        $this->db->from($this->tableName);
        $location_id = $this->session->userdata('admin_location_id');
        if($location_id!='0'){
         $this->db->where($this->tableName .'.province_id',$location_id);
        }
        $this->db->where('package_type', $package_type);
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_packages.country_id');
        $this->db->join('tbl_province', 'tbl_province.province_id=tbl_packages.province_id');
        $query = $this->db->get();
        //$this->db->where('package_type', $package_type);
        //$query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function getPackageListById($packageId) {
        $this->db->where($this->tableName . '.package_id', $packageId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function getPackageCategoryList() {
        $query = $this->db->get($this->tablePkgCat);
        $result = $query->result_array();
        return $result;
    }

    function getPackageItemList() {
        $query = $this->db->get($this->tablePkgItems);
        $result = $query->result_array();
        return $result;
    }

    function getItemsByPackageCat($category_id) {
        $this->db->where($this->tablePkgItems . '.category_id', $category_id);
        $query = $this->db->get($this->tablePkgItems);
        $result = $query->result_array();
        return $result;
    }

    function addPackage($package_type=FALSE,$image_name=FALSE) {
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('name'), $this->tableName);
        $this->db->set('slug', $slug);
 if ($this->input->post('online_cat_id'))
            $this->db->set('online_cat_id', $this->input->post('online_cat_id'));
 if ($image_name)
            $this->db->set('package_image', $image_name);
        if ($this->input->post('name'))
            $this->db->set('name', $this->input->post('name'));
        if ($this->input->post('price'))
            $this->db->set('price', $this->input->post('price'));
        if ($this->input->post('min_order_amount'))
            $this->db->set('min_order_amount', $this->input->post('min_order_amount'));
        if ($this->input->post('description'))
            $this->db->set('description', $this->input->post('description'));
        if($package_type)
             $this->db->set('package_type', $package_type);
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));        
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));
        $this->db->set('status', 'active');
        $this->db->set('add_time', time());

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($packageId,$image_name=FALSE) {
         if ($this->input->post('online_cat_id'))
            $this->db->set('online_cat_id', $this->input->post('online_cat_id'));
          if ($image_name)
            $this->db->set('package_image', $image_name);
        if ($this->input->post('name'))
            $this->db->set('name', $this->input->post('name'));
        if ($this->input->post('price'))
            $this->db->set('price', $this->input->post('price'));
        if ($this->input->post('min_order_amount'))
            $this->db->set('min_order_amount', $this->input->post('min_order_amount'));
        if ($this->input->post('description'))
            $this->db->set('description', $this->input->post('description'));
        if ($this->input->post('country_id'))
                $this->db->set('country_id', $this->input->post('country_id'));        
        if ($this->input->post('province_id'))
                $this->db->set('province_id', $this->input->post('province_id'));

        $this->db->where('package_id', $packageId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function updateStatus($packageId, $status) {
        $this->db->set('status', $status);
        $this->db->where('package_id', $packageId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($packageId) {
        $this->db->where('package_id', $packageId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

    function addPackageSpecifications($packageId) {
        $category_id = $this->input->post('category_id');
        $item_id = $this->input->post('item_id');
        $item_type = $this->input->post('item_type');
        $min_people = $this->input->post('min_people');
        $upgrade_price = $this->input->post('upgrade_price');
        $group_id = $this->input->post('group_id');
        $group_items = $this->input->post('group_items');
        $is_upgradable = $this->input->post('is_upgradable');
        $is_active = $this->input->post('is_active');

        foreach ($category_id as $key => $value) {
            $this->db->set('package_id', $packageId);
            if ($category_id[$key])
                $this->db->set('category_id', $value);
            if ($item_id[$key])
                $this->db->set('item_id', $item_id[$key]);
            if ($item_type[$key])
                $this->db->set('item_type', $item_type[$key]);
            if ($min_people[$key])
                $this->db->set('min_people', $min_people[$key]);
            if ($upgrade_price[$key])
                $this->db->set('upgrade_price', $upgrade_price[$key]);
            if ($group_id[$key])
                $this->db->set('group_id', $group_id[$key]);
            if ($group_items[$key])
                $this->db->set('group_items', $group_items[$key]);
            if ($is_upgradable[$key])
                $this->db->set('is_upgradable', $is_upgradable[$key]);
            if ($is_active[$key])
                $this->db->set('is_active', $is_active[$key]);

            $this->db->set('add_time', time());
            $query = $this->db->insert($this->tablePkgSpecification);
            $response = $this->db->insert_id();
        }
        return $response;
    }

    function getPackageSpecificationList($packageId) {
        $this->db->where('package_id', $packageId);
        $query = $this->db->get($this->tablePkgSpecification);
        $result = $query->result();
        return $result;
    }

    public function deleteSpecificationsByPackageId($packageId) {
        $this->db->where('package_id', $packageId);
        $response = $this->db->delete($this->tablePkgSpecification);
        return $response;
    }

    public function deleteSpecifications($specificId) {
        $this->db->where('pkg_specification_id', $specificId);
        $response = $this->db->delete($this->tablePkgSpecification);
        return $response;
    }

}
