<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package_Item_Model extends CI_Model {

        var $tableName = 'tbl_package_items';       
        var $tablePkgCategory = 'tbl_package_category';       
   
    function getPackageItemList() {  
        $this->db->select($this->tableName.'.*,tbl_package_category.pkg_cat_name');
        $this->db->from($this->tableName);        
        $this->db->join($this->tablePkgCategory, $this->tableName.'.category_id=tbl_package_category.pkg_cat_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    
    function getPackageItemsById($cateringItemId) {  
        $this->db->where('pkg_item_id',$cateringItemId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }  
    
    function getPackageCategoryList() {        
        $query = $this->db->get($this->tablePkgCategory);
        $result = $query->result_array();
        return $result;
    }    
   
    function add() {       
      
        if ($this->input->post('category_id'))
            $this->db->set('category_id', $this->input->post('category_id'));
        if ($this->input->post('item_name'))
            $this->db->set('item_name', $this->input->post('item_name'));
        if ($this->input->post('price'))
            $this->db->set('price', $this->input->post('price'));   
        
            $this->db->set('status', 'active');
            $this->db->set('add_time', time());           

            $query = $this->db->insert($this->tableName);
            $response=$this->db->insert_id();
        return $response;
    }   
 
    
    function update($cateringItemId){   

        if ($this->input->post('category_id'))
            $this->db->set('category_id', $this->input->post('category_id'));
        if ($this->input->post('item_name'))
            $this->db->set('item_name', $this->input->post('item_name'));
        if ($this->input->post('price'))
            $this->db->set('price', $this->input->post('price'));    
                     
        $this->db->where('pkg_item_id',$cateringItemId);    
        $query = $this->db->update($this->tableName);
        return $response;       
    }  
    
    public function updateStatus($cateringItemId,$status) {    
        $this->db->set('status',$status);
        $this->db->where('pkg_item_id',$cateringItemId);
        $response = $this->db->update($this->tableName);
        return $response; 
    }   
    
    public function delete($cateringItemId){        
        $this->db->where('pkg_item_id',$cateringItemId);
        $response = $this->db->delete($this->tableName);
        return $response; 
    } 
    
}
