<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package_Category_Model extends CI_Model {

        var $tableName = 'tbl_package_category';      

       
    function getCategoryList() { 
        $this->db->select($this->tableName . '.*,tbl_country.country_name,tbl_province.province_name');
        $this->db->from($this->tableName);
        $location_id = $this->session->userdata('admin_location_id');
        if($location_id!='0'){
        $this->db->where($this->tableName .'.province_id',$location_id);
        }
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_package_category.country_id');
        $this->db->join('tbl_province', 'tbl_province.province_id=tbl_package_category.province_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }  
    
    function getCategoryById($pkgCatId) {  
        $this->db->where('pkg_cat_id',$pkgCatId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    } 
    
    function add() {                     
            if($this->input->post('pkg_cat_name'))
            $this->db->set('pkg_cat_name', $this->input->post('pkg_cat_name'));          
            if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));        
            if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));    
            
            $this->db->set('status','active');
            $this->db->set('add_time',time());

            $query = $this->db->insert($this->tableName);
            $response=$this->db->insert_id();
        return $response;
    }   
     
     function update($pkgCatId){ 
            if($this->input->post('pkg_cat_name'))
                $this->db->set('pkg_cat_name', $this->input->post('pkg_cat_name'));   
            if ($this->input->post('country_id'))
                $this->db->set('country_id', $this->input->post('country_id'));        
            if ($this->input->post('province_id'))
                $this->db->set('province_id', $this->input->post('province_id'));

           $this->db->where('pkg_cat_id',$pkgCatId);
            $query = $this->db->update($this->tableName);
            return $response;          
    }  
    
    public function updateStatus($pkgCatId,$status) {  
        $this->db->set('status',$status);
        $this->db->where('pkg_cat_id',$pkgCatId);
        $response = $this->db->update($this->tableName);
        return $response; 
    }
    
    public function delete($pkgCatId){        
        $this->db->where('pkg_cat_id',$pkgCatId);
        $response = $this->db->delete($this->tableName);
        return $response; 
    } 
}
