<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class online_item_Model extends CI_Model {

        var $tableName = 'tbl_online_item';       
        var $tableCategory = 'tbl_online_category';       
        var $tableOnlineUnit = 'tbl_online_units';       
   
    function getOnlineItemList() {  
         $this->db->select($this->tableName.'.*,tbl_online_category.online_cat_name');
        $this->db->from($this->tableName);        
        $this->db->join($this->tableCategory, $this->tableName.'.category_id=tbl_online_category.online_cat_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    
    function getOnlineItemListById($onlineId) {  
        $this->db->where('online_item_id',$onlineId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }  
    
    function getOnlineCategoryList() {       
        $query = $this->db->get($this->tableCategory);
        $result = $query->result_array();
        return $result;
    }  
   
    function add($online_item_name,$online_item_image) {
        $slug = $this->common_model->create_unique_slug_for_common($online_item_name, $this->tableName);
        $this->db->set('slug', $slug);
        
        if ($online_item_image)
            $this->db->set('item_image', $online_item_image);
           
        if($this->input->post('category_id'))
            $this->db->set('category_id', $this->input->post('category_id')); 
        if ($this->input->post('item_name'))
            $this->db->set('item_name', $this->input->post('item_name'));
        if ($this->input->post('item_code'))
            $this->db->set('item_code', $this->input->post('item_code'));
        if ($this->input->post('item_description'))
            $this->db->set('item_description', $this->input->post('item_description'));     
        
        $this->db->set('status', 'active');
        $this->db->set('add_time', time());           

            $query = $this->db->insert($this->tableName);
            $response=$this->db->insert_id();
        return $response;
    }   
 
    
     function update($onlineId, $online_item_image){
        if ($online_item_image)
            $this->db->set('item_image', $online_item_image);  
        if($this->input->post('category_id'))
            $this->db->set('category_id', $this->input->post('category_id'));   
        if ($this->input->post('item_name'))
            $this->db->set('item_name', $this->input->post('item_name'));
        if ($this->input->post('item_code'))
            $this->db->set('item_code', $this->input->post('item_code'));
        if ($this->input->post('item_description'))
            $this->db->set('item_description', $this->input->post('item_description'));      
            
        $this->db->where('online_item_id',$onlineId);    
        $query = $this->db->update($this->tableName);
        return $response;       
    }  
    
    public function updateStatus($onlineId,$status) {  
        $this->db->set('status',$status);
        $this->db->where('online_item_id',$onlineId);
        $response = $this->db->update($this->tableName);
        return $response; 
    }   
    
    public function delete($onlineId){        
        $this->db->where('online_item_id',$onlineId);
        $response = $this->db->delete($this->tableName);
        return $response; 
    } 
    
    function getSubcategoryByCategory($category_id){                         
        $this->db->where('parent_id',$category_id);
        $query = $this->db->get($this->tableCategory);
        $result = $query->result_array();
        return $result;
    }     
    
    function addUnitSpecifications($onlineItemId) {      
        $unit_name = $this->input->post('unit_name');
        $unit_prices = $this->input->post('unit_prices');    
       // $no_of_people = $this->input->post('no_of_people');
        $is_active = $this->input->post('is_active');
     
        foreach ($unit_name as $key =>$value) {
            $this->db->set('online_item_id', $onlineItemId);
            if ($unit_name[$key])
                $this->db->set('unit_name', $value);
            if ($unit_prices[$key])
                $this->db->set('unit_prices', $unit_prices[$key]);          
//            if ($no_of_people[$key])
//                $this->db->set('no_of_people', $no_of_people[$key]);
            if ($is_active[$key])
                $this->db->set('is_active', $is_active[$key]);           
           
                $this->db->set('add_time', time());                
                $query = $this->db->insert($this->tableOnlineUnit);
                $response = $this->db->insert_id();
          }
        return $response;
    }
    
    function getUnitSpecificationList($onlineItemId) {
        $this->db->where('online_item_id', $onlineItemId);
        $query = $this->db->get($this->tableOnlineUnit);
        $result = $query->result();
        return $result;
    }
    
     public function deleteUnitSpecifications($onlineItemId) {
        $this->db->where('online_item_id', $onlineItemId);
        $response = $this->db->delete($this->tableOnlineUnit);
        return $response;
    }
   
}
