<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Menu_Item_Model extends CI_Model {

        var $tableName = 'tbl_menu_item';       
        var $tableCategory = 'tbl_menu_category';   
        var $tableMenuUnits = 'tbl_menu_units'; 
   
    function getMenuItemList() {  
         $this->db->select($this->tableName.'.*,tbl_menu_category.item_cat_name');
        $this->db->from($this->tableName);        
        $this->db->join($this->tableCategory, $this->tableName.'.category_id=tbl_menu_category.item_cat_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    
    function getMenuItemListById($menuId) {  
        $this->db->where('item_id',$menuId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }  
    
    function getMenuCategoryList() {        
        $query = $this->db->get($this->tableCategory);
        $result = $query->result_array();
        return $result;
    }    
   
    function add($menu_item_name, $menu_item_image) {  
        $slug = $this->common_model->create_unique_slug_for_common($menu_item_name, $this->tableName);
        $this->db->set('slug', $slug);
        if ($menu_item_image)
            $this->db->set('item_image', $menu_item_image);
        if ($this->input->post('category_id'))
            $this->db->set('category_id', $this->input->post('category_id'));
        if ($this->input->post('item_name'))
            $this->db->set('item_name', $this->input->post('item_name'));
        if ($this->input->post('item_code'))
            $this->db->set('item_code', $this->input->post('item_code'));
        if ($this->input->post('item_price'))
            $this->db->set('item_price', $this->input->post('item_price'));
     
            $this->db->set('item_description', $this->input->post('item_description'));      
        
          
        $this->db->set('status', 'active');
        $this->db->set('add_time', time());           

            $query = $this->db->insert($this->tableName);
            $response=$this->db->insert_id();
        return $response;
    }   
 
    
    function update($menuId, $menu_item_image){    
        if ($menu_item_image)
            $this->db->set('item_image', $menu_item_image);
        if ($this->input->post('category_id'))
            $this->db->set('category_id', $this->input->post('category_id'));
        if ($this->input->post('item_name'))
            $this->db->set('item_name', $this->input->post('item_name'));
        if ($this->input->post('item_code'))
            $this->db->set('item_code', $this->input->post('item_code'));
        if ($this->input->post('item_price'))
            $this->db->set('item_price', $this->input->post('item_price'));

            $this->db->set('item_description', $this->input->post('item_description'));    
                     
        $this->db->where('item_id',$menuId);    
        $query = $this->db->update($this->tableName);
        return $response;       
    }  
    
    public function updateStatus($menuId,$status) {    
        $this->db->set('status',$status);
        $this->db->where('item_id',$menuId);
        $response = $this->db->update($this->tableName);
        return $response; 
    }   
    
    public function delete($menuId){        
        $this->db->where('item_id',$menuId);
        $response = $this->db->delete($this->tableName);
        return $response; 
    } 
    
    function addUnitSpecifications($menuItemId) {      
        $unit_name = $this->input->post('unit_name');
        $unit_prices = $this->input->post('unit_prices');    
        $no_of_people = $this->input->post('no_of_people');
        $is_active = $this->input->post('is_active');
     
        foreach ($unit_name as $key =>$value) {
            $this->db->set('menu_item_id', $menuItemId);
            if ($unit_name[$key])
                $this->db->set('unit_name', $value);
            if ($unit_prices[$key])
                $this->db->set('unit_prices', $unit_prices[$key]);          
            if ($no_of_people[$key])
                $this->db->set('no_of_people', $no_of_people[$key]);
            if ($is_active[$key])
                $this->db->set('is_active', $is_active[$key]);           
           
                $this->db->set('add_time', time());                
                $query = $this->db->insert($this->tableMenuUnits);
                $response = $this->db->insert_id();
          }
        return $response;
    }
    
    function getUnitSpecificationList($menuItemId) {
        $this->db->where('menu_item_id', $menuItemId);
        $query = $this->db->get($this->tableMenuUnits);
        $result = $query->result();
        return $result;
    }
    
     public function deleteUnitSpecifications($menuItemId) {
        $this->db->where('menu_item_id', $menuItemId);
        $response = $this->db->delete($this->tableMenuUnits);
        return $response;
    }
    
}
