<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Header_Link_Model extends CI_Model {

    var $tableName = 'tbl_header_links';

    function getHeaderLinkList() {       
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function getHeaderLinksById($headerId) {
        if ($headerId != '')
            $this->db->where('header_link_id', $headerId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function getParentPageRecords() {    
//        $this->db->where($this->tableName . '.header_type', 'parent');
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function addHeaderLink() {   
        if ($this->input->post('link_title'))
            $this->db->set('link_title', $this->input->post('link_title'));
        if ($this->input->post('link_url'))
            $this->db->set('link_url', $this->input->post('link_url'));
        if($this->input->post('parent_header'))      
        $this->db->set('parent_header', $this->input->post('parent_header'));
        if($this->input->post('header_order'))      
        $this->db->set('header_order', $this->input->post('header_order'));
  
        $this->db->set('status', 'active');
        $this->db->set('add_time', time());    
      
        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function updateHeaderLink($headerId) {
        if ($this->input->post('link_title'))
            $this->db->set('link_title', $this->input->post('link_title'));
        if ($this->input->post('link_url'))
            $this->db->set('link_url', $this->input->post('link_url'));
        if($this->input->post('parent_header'))      
        $this->db->set('parent_header', $this->input->post('parent_header'));  
               if($this->input->post('header_order'))      
        $this->db->set('header_order', $this->input->post('header_order'));
             
        $this->db->where('header_link_id', $headerId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function updateStatus($headerId, $action) {
        $this->db->set('status', $action);
        $this->db->where('header_link_id', $headerId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($headerId) {
        $this->db->where('header_link_id', $headerId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

}