<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Footer_Link_Model extends CI_Model {

    var $tableName = 'tbl_footer_links';

    function getFooterLinkList() {       
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function getFooterLinksById($footerId) {
        if ($footerId != '')
            $this->db->where('footer_link_id', $footerId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function getParentPageRecords() {    
//        $this->db->where($this->tableName . '.footer_type', 'parent');
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function addFooterLink() {   
        if ($this->input->post('link_title'))
            $this->db->set('link_title', $this->input->post('link_title'));
        if ($this->input->post('link_url'))
            $this->db->set('link_url', $this->input->post('link_url'));
        if($this->input->post('parent_footer'))      
        $this->db->set('parent_footer', $this->input->post('parent_footer'));
        if($this->input->post('footer_order'))      
        $this->db->set('footer_order', $this->input->post('footer_order'));
  
        $this->db->set('status', 'active');
        $this->db->set('add_time', time());    
      
        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function updateFooterLink($footerId) {
        if ($this->input->post('link_title'))
            $this->db->set('link_title', $this->input->post('link_title'));
        if ($this->input->post('link_url'))
            $this->db->set('link_url', $this->input->post('link_url'));
        if($this->input->post('parent_footer'))      
        $this->db->set('parent_footer', $this->input->post('parent_footer'));  
               if($this->input->post('footer_order'))      
        $this->db->set('footer_order', $this->input->post('footer_order'));
             
        $this->db->where('footer_link_id', $footerId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function updateStatus($footerId, $action) {
        $this->db->set('status', $action);
        $this->db->where('footer_link_id', $footerId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($footerId) {
        $this->db->where('footer_link_id', $footerId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

}