<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Email_Template_Model extends CI_Model {

    var $tableName = 'tbl_email_template';
    

    function getEmailTemplateList() { 
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }
    
    function getEmailTemplateById($templateId) {     
            $this->db->where($this->tableName . '.template_id', $templateId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function add() {

        if ($this->input->post('email_from_name'))
            $this->db->set('email_from_name', $this->input->post('email_from_name'));
        if ($this->input->post('sender_from_email'))
            $this->db->set('sender_from_email', $this->input->post('sender_from_email'));
        if ($this->input->post('sender_to_email'))
            $this->db->set('sender_to_email', $this->input->post('sender_to_email'));
        if ($this->input->post('email_template_title'))
            $this->db->set('email_template_title', $this->input->post('email_template_title'));   
        if ($this->input->post('email_subject'))
            $this->db->set('email_subject', $this->input->post('email_subject'));
        if ($this->input->post('template_description'))
            $this->db->set('template_description', $this->input->post('template_description'));

        $this->db->set('status', 'active');
        $this->db->set('add_time', time());

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($templateId) {
        
        if ($this->input->post('email_from_name'))
            $this->db->set('email_from_name', $this->input->post('email_from_name'));
        if ($this->input->post('sender_from_email'))
            $this->db->set('sender_from_email', $this->input->post('sender_from_email'));
        if ($this->input->post('sender_to_email'))
            $this->db->set('sender_to_email', $this->input->post('sender_to_email'));
        if ($this->input->post('email_template_title'))
            $this->db->set('email_template_title', $this->input->post('email_template_title'));   
        if ($this->input->post('email_subject'))
            $this->db->set('email_subject', $this->input->post('email_subject'));
        if ($this->input->post('template_description'))
            $this->db->set('template_description', $this->input->post('template_description'));

        $this->db->where('template_id', $templateId);
        $query = $this->db->update($this->tableName);
        return $response;
    }
    
    public function updateStatus($templateId, $status) {
        $this->db->set('status', $status);
        $this->db->where('template_id', $templateId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($templateId) {
        $this->db->where('template_id', $templateId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }


}