<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Delivery_Charge_Model extends CI_Model {

    var $tableName = 'tbl_area_wise_delivery_charges';

    function getDeliveryChargeList() {
        $this->db->select($this->tableName . '.*,tbl_country.country_name,tbl_province.province_name');
        $this->db->from($this->tableName);
        $location_id = $this->session->userdata('admin_location_id');
        if($location_id!='0'){
        $this->db->where($this->tableName .'.province_id',$location_id);
        }
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_area_wise_delivery_charges.country_id');
        $this->db->join('tbl_province', 'tbl_province.province_id=tbl_area_wise_delivery_charges.province_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    

    function getDeliveryChargeListByArea($areaId) {     
        $this->db->where($this->tableName . '.area_id', $areaId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function add() {
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));
        if ($this->input->post('area_name'))
            $this->db->set('area_name', $this->input->post('area_name'));
        if ($this->input->post('area_pincode'))
            $this->db->set('area_pincode', $this->input->post('area_pincode'));
        if ($this->input->post('charges'))
            $this->db->set('charges', $this->input->post('charges'));

        $this->db->set('status', 'active');
        $this->db->set('add_time', time());

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($areaId) {
        
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));
        if ($this->input->post('area_name'))
            $this->db->set('area_name', $this->input->post('area_name'));
        if ($this->input->post('area_pincode'))
            $this->db->set('area_pincode', $this->input->post('area_pincode'));
        if ($this->input->post('charges'))
            $this->db->set('charges', $this->input->post('charges')); 

        $this->db->where('area_id', $areaId);
        $query = $this->db->update($this->tableName);
        return $response;
    }
    
    public function updateStatus($areaId, $status) {
        $this->db->set('status', $status);
        $this->db->where('area_id', $areaId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($areaId) {
        $this->db->where('area_id', $areaId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }


}