<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class coupon_Model extends CI_Model {

    var $tableName = 'tbl_coupons';

    function getCouponList() {
        $this->db->select($this->tableName . '.*,tbl_country.country_name,tbl_province.province_name');
        $this->db->from($this->tableName);
        $location_id = $this->session->userdata('admin_location_id');
        if($location_id!='0'){
        $this->db->where($this->tableName .'.province_id',$location_id);
        }
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_coupons.country_id');
        $this->db->join('tbl_province', 'tbl_province.province_id=tbl_coupons.province_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    

    function getCouponListById($couponId) {     
            $this->db->where($this->tableName . '.coupon_id', $couponId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function add() {
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));

        if ($this->input->post('coupon_code'))
            $this->db->set('coupon_code', $this->input->post('coupon_code'));
        if ($this->input->post('coupon_price'))
            $this->db->set('coupon_price', $this->input->post('coupon_price'));  
        if ($this->input->post('minimum_order_amount'))
            $this->db->set('minimum_order_amount', $this->input->post('minimum_order_amount'));  
  
        $this->db->set('coupon_type', $this->input->post('coupon_type'));
          if($this->input->post('expiration_date'))
            $this->db->set('expiration_date', strtotime($this->input->post('expiration_date')));            
          

        $this->db->set('status', 'active');
        $this->db->set('add_time', time());
        $this->db->set('update_time', time());

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($couponId) {

        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));

        if ($this->input->post('coupon_code'))
            $this->db->set('coupon_code', $this->input->post('coupon_code'));
        if ($this->input->post('coupon_price'))
            $this->db->set('coupon_price', $this->input->post('coupon_price'));  
        if ($this->input->post('minimum_order_amount'))
            $this->db->set('minimum_order_amount', $this->input->post('minimum_order_amount'));  
  
        $this->db->set('coupon_type', $this->input->post('coupon_type'));
       if($this->input->post('expiration_date'))
            $this->db->set('expiration_date', strtotime($this->input->post('expiration_date')));  
               
        $this->db->set('update_time', time());

        $this->db->where('coupon_id', $couponId);
        $query = $this->db->update($this->tableName);
        return $response;
    }
    
    public function updateStatus($couponId, $status) {
        $this->db->set('status', $status);
        $this->db->where('coupon_id', $couponId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($couponId) {
        $this->db->where('coupon_id', $couponId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }


}