<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Content_Model extends CI_Model {

    var $tableName = 'tbl_page';

    function getContentList($location_id) { 
        $location_id = $this->session->userdata('admin_location_id');
        if($location_id!='0'){
        $this->db->where($this->tableName.'.province_id',$location_id);
        }
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function getContentListById($contentId) {
        if ($contentId != '')
            $this->db->where('page_id', $contentId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function getParentPageRecords() {    
        //$this->db->where($this->tableName . '.header_type', 'parent');
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    }

    function addContent() {
        $slug = $this->common_model->create_unique_slug_for_common($this->input->post('page_title'), $this->tableName);
        $this->db->set('slug', $slug);
      
        if ($this->input->post('page_title'))
            $this->db->set('page_title', $this->input->post('page_title'));     
        if ($this->input->post('page_heading'))
            $this->db->set('page_heading', $this->input->post('page_heading'));
        if ($this->input->post('page_content'))
            $this->db->set('page_content', $this->input->post('page_content'));
        if ($this->input->post('country_id'))
                 $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
                 $this->db->set('province_id', $this->input->post('province_id'));
      
        
        $this->db->set('content_type', $this->input->post('content_type'));           

        $this->db->set('status', 'active');
        $this->db->set('add_time', time());
      
        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function updateContent($contentId) {
        
        if ($this->input->post('page_title'))
            $this->db->set('page_title', $this->input->post('page_title'));
        if ($this->input->post('slug'))
            $this->db->set('slug', $this->input->post('slug'));
        if ($this->input->post('page_heading'))
            $this->db->set('page_heading', $this->input->post('page_heading'));
        if ($this->input->post('page_content'))
            $this->db->set('page_content', $this->input->post('page_content'));
        if ($this->input->post('country_id'))
                 $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
                 $this->db->set('province_id', $this->input->post('province_id'));
        
        $this->db->set('content_type', $this->input->post('content_type'));   
     
        $this->db->where('page_id', $contentId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    function updateSlug($contentId) {
        $this->db->set('status', $this->input->post('status'));
        $this->db->where('page_id', $contentId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function updateStatus($contentId, $action) {
        $this->db->set('status', $action);
        $this->db->where('page_id', $contentId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($contentId) {
        $this->db->where('page_id', $contentId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

}