<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class City_Model extends CI_Model {

    var $tableName = 'tbl_city';
    var $tableCountry = 'tbl_country';
    var $tableProvince = 'tbl_province';

    function getCityList() {
        $this->db->select($this->tableName.'.*,tbl_country.country_name,tbl_province.province_name');
        $this->db->from($this->tableName);
        $this->db->join($this->tableCountry,$this->tableCountry.'.ct_id=tbl_city.country_id');
        $this->db->join($this->tableProvince,$this->tableProvince.'.province_id=tbl_city.province_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }
    
    function getCityListById($cityId) {  
        $this->db->where('c_id', $cityId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }
    
    function getCountryList() {
        $query = $this->db->get($this->tableCountry);
        $result = $query->result_array();
        return $result;
    }     
    
    function getRegionByCountry($country_id){                         
        $this->db->where('country_id',$country_id);
        $query = $this->db->get($this->tableProvince);
        $result = $query->result_array();
        return $result;
    } 
    
    function getCityByRegion($province_id){                         
        $this->db->where('province_id',$province_id);
        $query = $this->db->get($this->tableName);
        $result = $query->result_array();
        return $result;
    } 

    function add($city_name) {
        
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));        
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));
       
        $slug = $this->common_model->create_unique_slug_for_common($city_name, 'tbl_city');
        $this->db->set('slug', $slug);
        if ($this->input->post('city_name'))
            $this->db->set('city_name', $this->input->post('city_name'));       
        if ($this->input->post('meta_title'))
            $this->db->set('meta_title', $this->input->post('meta_title'));
        if ($this->input->post('meta_keywords'))
            $this->db->set('meta_keywords', $this->input->post('meta_keywords'));
        if ($this->input->post('meta_description'))
            $this->db->set('meta_description', $this->input->post('meta_description'));
        
        $this->db->set('status', 'active');
        $this->db->set('add_time', time());     

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($cityId) {
       
        $city_name = $this->input->post('city_name');
        $default_city_name = $this->getDefaultCityName($cityId);
        if ($city_name != $default_city_name) {
            $slug = $this->common_model->create_unique_slug_for_common($city_name, 'tbl_city');
            $this->db->set('slug', $slug);
        }
        if ($this->input->post('city_name'))
            $this->db->set('city_name', $this->input->post('city_name'));
        if ($this->input->post('country_id'))
            $this->db->set('country_id', $this->input->post('country_id'));
        if ($this->input->post('province_id'))
            $this->db->set('province_id', $this->input->post('province_id'));
        if ($this->input->post('meta_title'))
            $this->db->set('meta_title', $this->input->post('meta_title'));
        if ($this->input->post('meta_keywords'))
            $this->db->set('meta_keywords', $this->input->post('meta_keywords'));
        if ($this->input->post('meta_description'))
            $this->db->set('meta_description', $this->input->post('meta_description'));
        
        $this->db->set('status', 'active');
        $this->db->set('add_time', time());
        $this->db->where('c_id', $cityId);

        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function getDefaultCityName($cityId) {

        $this->db->where('c_id', $cityId);
        $query = $this->db->get($this->tableName);
        $result = $query->row();
        return $result->city_name;
    }

    public function updateStatus($cityId, $action) {

        $this->db->set('status', $action);
        $this->db->where('c_id', $cityId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($cityId) {
        $this->db->where('c_id', $cityId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

}