<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Banner_Model extends CI_Model {

    var $tableName = 'tbl_banner';

    function getBannerList() {
        $this->db->select($this->tableName . '.*,tbl_country.country_name,tbl_province.province_name');
        $this->db->from($this->tableName);
        $location_id = $this->session->userdata('admin_location_id');
        if ($location_id != '0') {
            $this->db->where($this->tableName . '.province_id', $location_id);
        }
        $this->db->join('tbl_country', 'tbl_country.ct_id=tbl_banner.country_id');
        $this->db->join('tbl_province', 'tbl_province.province_id=tbl_banner.province_id');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    function getBannerListById($bannerId) {
        $this->db->where($this->tableName . '.banner_id', $bannerId);
        $query = $this->db->get($this->tableName);
        $result = $query->row_array();
        return $result;
    }

    function add($banner_image) {
        $this->db->set('country_id', $this->input->post('country_id'));
        $this->db->set('province_id', $this->input->post('province_id'));
        $this->db->set('banner_title', $this->input->post('banner_title'));
        if ($banner_image)
            $this->db->set('banner_image', $banner_image);
        $this->db->set('banner_text', $this->input->post('banner_text'));

        $this->db->set('status', 'active');
        $this->db->set('add_time', time());

        $query = $this->db->insert($this->tableName);
        $response = $this->db->insert_id();
        return $response;
    }

    function update($bannerId, $banner_image) {
        if ($banner_image)
            $this->db->set('banner_image', $banner_image);
        $this->db->set('banner_title', $this->input->post('banner_title'));
        $this->db->set('banner_text', $this->input->post('banner_text'));
        $this->db->set('country_id', $this->input->post('country_id'));
        $this->db->set('province_id', $this->input->post('province_id'));
        $this->db->set('status', 'active');

        $this->db->where('banner_id', $bannerId);
        $query = $this->db->update($this->tableName);
        return $response;
    }

    public function updateStatus($bannerId, $status) {

        $this->db->set('status', $status);
        $this->db->where('banner_id', $bannerId);
        $response = $this->db->update($this->tableName);
        return $response;
    }

    public function delete($bannerId) {
        $this->db->where('banner_id', $bannerId);
        $response = $this->db->delete($this->tableName);
        return $response;
    }

}
