<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Welcome extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkUserLocation();
        $this->load->model('news_subscribe_model', 'subscribe');
        $this->load->model('cart_items_model', 'cart_items');
        $this->load->model('content_model', 'content');
        $this->load->model('banner_model', 'banner');
        $this->load->model('enquiry_model', 'enquiry');
        $this->load->model('mailsending_model', 'sendingEmail');
        $this->load->library('form_validation');
        $this->load->helper('captcha');
    }

    public function index() {
        $data['page_name'] = 'home';
        $data['banner_data'] = $this->banner->getBannerRecords();
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/home');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function getContactUs() {
        if (!empty($_POST)) {
            $data['full_name '] = $this->input->post('full_name');
            $data['email_id'] = $this->input->post('email_id');
            $data['message'] = $this->input->post('message');
            $this->enquiry->insertNewEnquiry();
            $this->sendingEmail->contactusmail();
        }
    }

    public function register_security_code_refresh() {
        $vals = array(
            'img_path' => './assets/captcha/',
            'img_url' => site_url() . 'assets/captcha/',
            // 'font_path'	 => './path/to/fonts/texb.ttf',
            'img_width' => '150',
            'img_height' => '40',
            'expiration' => 7200
        );

        $cap = create_captcha($vals);
        $data = array(
            'captcha_time' => $cap['time'],
            'ip_address' => $this->input->ip_address(),
            'word' => $cap['word']
        );

        $query = $this->db->insert_string('captcha', $data);
        $this->db->query($query);
        echo $output['captcha_image'] = $cap['image'];
    }

}
