<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class package extends CI_Controller {

    function __construct() {
        parent::__construct();
         $this->common_model->checkUserLocation();
        $this->load->model('tray_category_model', 'trayCat');
        $this->load->model('tray_item_model', 'trayItem');
        $this->load->model('package_model', 'package');
        $this->load->model('content_model', 'content');
        $this->load->model('area_model', 'area');
        $this->load->model('cart_items_model', 'cart_items');
        $this->load->model('province_model', 'province');
        $this->load->model('cart_model', 'cart');
    }

    public function index() {
        $this->session->unset_userdata('no_of_people');
        if (!empty($_POST)) {
            $no_of_people = $this->input->post('no_of_people');
            $this->package->configurePackage($no_of_people);
        }
        $data['breadcrumb'] = 'package';
        $data['page_name'] = 'package';
        $data['package_data'] = $this->package->getPackageRecords();
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/package');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function configurePackage($packageId) {
        if (!empty($_POST)) {
            $no_of_people = $this->input->post('no_of_people');
            $package_data = $this->package->getPackageRecordsById($packageId);
            $min_people = $package_data['min_order_amount'];

            if ($no_of_people >= $min_people && $no_of_people <= 100) {
                $this->session->set_userdata('no_of_people', $no_of_people);
                redirect(site_url('package-detail/' . $packageId . '/' . $no_of_people));
                exit;
            } else if ($no_of_people > 100) {
                $this->session->set_userdata('packageErrorMessage', 'For more info please email info@a1sweets.com');
                redirect(site_url('package'));
                exit;
            } else {
                $this->session->set_flashdata('errorMessage', 'You have entered less no of people for this package');
                redirect(site_url('package'));
                exit;
            }
        }
    }

    public function getPackgeDetail($packageId, $no_of_people) {
        if ($no_of_people > 100) {
            $this->session->set_userdata('packageErrorMessage', 'For more info please email info@a1sweets.com');
            redirect(site_url('package'));
            exit;
        }
        $min_people = $this->common_model->getSingleFieldFromAnyTable('min_order_amount', 'package_id', $packageId, 'tbl_packages');
        if ($no_of_people < $min_people) {
            redirect(site_url('package'));
            exit;
        } else {
            $data['breadcrumb'] = 'package';
            $data['page_name'] = 'package';
            $data['eraseCache'] = true;
            $data['no_of_people'] = $no_of_people;
            $data['package_detail'] = $this->package->getPackageRecordsById($packageId);
            $data['pkg_category_data'] = $this->package->getAllPackageCategory();
            $this->load->view($this->config->item('template') . '/header', $data);
            $this->load->view($this->config->item('template') . '/package_detail');
            $this->load->view($this->config->item('template') . '/footer');
        }
    }

}
