<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Enquiry extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('enquiry_model', 'enquiry');
        $this->load->model('cart_items_model', 'cart_items');
        $this->load->model('content_model', 'content');
        $this->load->model('province_model', 'province');
        $this->load->model('mailsending_model', 'sendingEmail');
        $this->load->library('form_validation');
        $this->load->helper('captcha');
    }

    public function index() {
        #============================= Captcha Code ============================================#
        $vals = array(
            'img_path' => './assets/captcha/',
            'img_url' => site_url() . 'assets/captcha/',
            'font_path' => './path/to/fonts/texb.ttf',
            'img_width' => '150',
            'img_height' => '40',
            'expiration' => 7200
        );
        $cap = create_captcha($vals);
        $data = array(
            'captcha_time' => $cap['time'],
            'ip_address' => $this->input->ip_address(),
            'word' => $cap['word']
        );
        $query = $this->db->insert_string('captcha', $data);
        $this->db->query($query);
        $data['captcha_image'] = $cap['image'];
        #========================================================================================#
        if (!empty($_POST)) {
            //    pr($_POST);die;
            #====================================== Captcha Validation =================================#
            //  First, delete old captchas
            $expiration = time() - 7200; // Two hour limit
            $this->db->query("DELETE FROM captcha WHERE captcha_time < " . $expiration);
            // Then see if a captcha exists:
            $sql = "SELECT COUNT(*) AS count FROM captcha WHERE word = ? AND ip_address = ? AND captcha_time > ?";
            $binds = array($_POST['captcha'], $this->input->ip_address(), $expiration);
            $query = $this->db->query($sql, $binds);
            $row = $query->row();
            if ($row->count == 0) {
                $this->form_validation->set_rules('captcha', 'Security Code ', 'trim|required|matches[row]');
            }
            #============================================================================================#
            $data['full_name'] = $this->input->post('full_name');
            $data['email_id'] = $this->input->post('email_id');
            $data['phone_no'] = $this->input->post('phone_no');
            $data['order_no'] = $this->input->post('order_no');
            $data['location_id'] = $this->input->post('location_id');
            $data['message'] = $this->input->post('message');
            $this->form_validation->set_rules('full_name', 'Name', 'trim|required');
            $this->form_validation->set_rules('phone_no', 'Phone No', 'trim|required');
            $this->form_validation->set_rules('email_id', 'Email Id', 'trim|required|valid_email');
            $this->form_validation->set_rules('location_id', 'Location', 'trim|required');
            $this->form_validation->set_rules('message', 'Message', 'trim|required');
            if ($this->form_validation->run()) {
                $this->enquiry->insertNewEnquiry();
                $this->sendingEmail->contactusmail();
                $this->session->set_flashdata('enquirySuccessMessage', 'You Have Successfully Send Your Contact Detail');
                redirect(site_url('inquiry'));
                exit();
            } else {
                $this->session->set_flashdata('enquiryErrorMessage', 'There Is Some Error');
            }
        }
        $data['province_list'] = $this->province->getAllProvince();
        $data['current_slug'] = $current_slug = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
        $content_detail = $this->content->getContentRecordBySlug($current_slug);
        $data['page_heading'] = $content_detail->page_heading;
        $data['page_content'] = $content_detail->page_content;
        $data['page_name'] = $content_detail->slug;
        $data['breadcumb'] = 'Inquiry';
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/enquiry');
        $this->load->view($this->config->item('template') . '/footer');
    }

}
