<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Catering extends CI_Controller {

    function __construct() {
        parent::__construct();
         $this->common_model->checkUserLocation();
        $this->load->model('tray_category_model', 'trayCat');
        $this->load->model('tray_item_model', 'trayItem');
        $this->load->model('online_category_model', 'onlineCat');
        $this->load->model('online_item_model', 'onlineItem');
        $this->load->model('content_model', 'content');
        $this->load->model('cart_model', 'cart');
        $this->load->model('area_model', 'area');
        $this->load->model('province_model', 'province');
        $this->load->model('cart_items_model', 'cart_items');
        //$this->load->library('cart');
    }

    public function index() {
        $data['tray_category'] = $this->trayCat->getTrayCategorylist();
        $data['breadcumb'] = 'Order By Tray';
        $data['page_name'] = 'order-by-tray';
        $data['page_heading'] = 'Order By Tray';
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/catering');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function itemByCategory($slug) {
        $category_row = $this->common_model->getSingleRowFromAnyTable('slug', $slug, $this->trayCat->tableName);
        $data['category_id'] = $category_id = $category_row->tray_cat_id;
        $breadcumb = $category_row->tray_cat_name . ' / ';
        $breadcumb = '<a href="' . site_url('order-by-tray') . '">Order By Tray</a> / ' . $breadcumb;
        $data['METATITLE'] = $category_row->meta_title . ' | ' . $this->config->item('site_title');
        $data['METAKEYWORDS'] = $category_row->meta_keywords;
        $data['METADESCRIPTION'] = $category_row->meta_description;
        $data['breadcumb'] = $breadcumb;
        $data['page_name'] = 'order-by-tray';
        $data['page_heading'] = 'Order By Tray';
        $data['area_list'] = $this->area->getAreaList();
        $data['tray_item_list'] = $this->trayItem->getTrayItemByCatId($category_id);
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/catering_item');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function itemByItemSlug($slug) {
        $item_row = $this->common_model->getSingleRowFromAnyTable('slug', $slug, $this->trayItem->tableName);
        $breadcumb = $item_row->item_name . ' / ';
        $breadcumb = '<a href="' . site_url('order-by-tray') . '">Order By Tray</a> / ' . $breadcumb;
        $data['breadcumb'] = $breadcumb;
        $data['item_id'] = $item_row->tray_item_id;
        $data['item_name'] = $item_row->item_name;
        $data['page_name'] = 'order-by-tray';
        $data['page_heading'] = 'Order By Tray';
        $data['area_list'] = $this->area->getAreaList();
        $data['tray_item_list'] = $this->trayItem->getTrayItemByCatId($item_row->category_id);
        $data['unit_data'] = $this->trayItem->getUnitsByTrayItemId($item_row->tray_item_id);
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/catering_item');
        $this->load->view($this->config->item('template') . '/footer');
    }
public function online_order() {
        $data['online_category'] = $this->onlineCat->getOnlineCategorylist(0);
        $data['breadcumb'] = 'Online Order';
        $data['page_name'] = 'online-order';
        $data['page_heading'] = 'Online Order';
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/online_order');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function online_order_items($slug) {
        $data['online_category'] = $this->onlineCat->getOnlineCategorylist(0);
        $data['category_detail']=$category_row = $this->common_model->getSingleRowFromAnyTable('slug', $slug, $this->onlineCat->tableName);
        $data['category_id'] = $category_id = $category_row->online_cat_id;
        $breadcumb = $category_row->online_cat_name . ' / ';
        $breadcumb = '<a href="' . site_url('online-order') . '">Online Order</a> / ' . $breadcumb;
        $data['METATITLE'] = $category_row->meta_title . ' | ' . $this->config->item('site_title');
        $data['METAKEYWORDS'] = $category_row->meta_keywords;
        $data['METADESCRIPTION'] = $category_row->meta_description;
        $data['breadcumb'] = $breadcumb;
        $data['page_name'] = 'online-order';
        $data['page_heading'] = 'Online Order';
        $data['area_list'] = $this->area->getAreaList();
        $data['online_item_list'] = $this->onlineItem->getOnlineItemByCatId($category_id);
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/online_order_item');
        $this->load->view($this->config->item('template') . '/footer');
    }
}
