<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blog extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('blog_model', 'blog');
        $this->load->model('cart_items_model', 'cart_items');
        $this->load->model('content_model', 'content');
        $this->load->library('form_validation');
        $this->load->helper('captcha');
    }

    public function index() {
        $data['blog_data'] = $this->blog->getBlogRecords();
        $data['page_name'] = 'blog';
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/blog');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function blogDetail($slug) {
        $data['blog_data'] = $blog_data = $this->blog->getBlogRecordBySlug($slug);
        if (sizeof($blog_data) == 0) {
            redirect(base_url());
        }
        $data['blog_id'] = $blog_id = $blog_data['blog_id'];
        $data['blog_comment'] = $this->blog->getBlogCommentList($blog_id);
//        #============================= Captcha Code ============================================#
        $vals = array(
            'img_path' => './assets/captcha/',
            'img_url' => site_url() . 'assets/captcha/',
            'font_path' => './path/to/fonts/texb.ttf',
            'img_width' => '150',
            'img_height' => '40',
            'expiration' => 7200
        );
        $cap = create_captcha($vals);
        $data['captcha_data'] = array(
            'captcha_time' => $cap['time'],
            'ip_address' => $this->input->ip_address(),
            'word' => $cap['word']
        );
        $query = $this->db->insert_string('captcha', $data['captcha_data']);
        $this->db->query($query);
        $data['captcha_image'] = $cap['image'];
//        #========================================================================================#
        if (!empty($_POST)) {

//            #====================================== Captcha Validation =================================#
            // First, delete old captchas
            $expiration = time() - 7200; // Two hour limit
            $this->db->query("DELETE FROM captcha WHERE captcha_time < " . $expiration);
            // Then see if a captcha exists:
            $sql = "SELECT COUNT(*) AS count FROM captcha WHERE word = ? AND ip_address = ? AND captcha_time > ?";
            $binds = array($_POST['captcha'], $this->input->ip_address(), $expiration);
            $query = $this->db->query($sql, $binds);
            $row = $query->row();
            if ($row->count == 0) {
                $this->form_validation->set_rules('captcha', 'Security Code ', 'trim|required|matches[row]');
            }
//            #============================================================================================#
            $data['comment_by'] = $this->input->post('comment_by');
            $data['email'] = $this->input->post('email');
            $data['phone'] = $this->input->post('phone');
            $data['subject'] = $this->input->post('subject');
            $data['comment'] = $this->input->post('comment');
            $this->form_validation->set_rules('comment_by', 'Name', 'trim|required');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');
            $this->form_validation->set_rules('subject', 'subject', 'trim|required');
            $this->form_validation->set_rules('phone', 'phone', 'trim|required');
            $this->form_validation->set_rules('comment', 'Comment', 'trim|required');
            if ($this->form_validation->run()) {
                $this->blog->addBlogComment($blog_id);
                $this->session->set_flashdata('CommentSuccessMessage', 'Your Comment Has been successfully posted');
                redirect(site_url('blog/'.$slug));
                exit;
            }
        }

        $data['page_name'] = 'blog';
        $breadcumb = $blog_data['slug'];
        $data['breadcumb'] = '<a href="' . site_url('blog') . '">blog</a> / ' . $breadcumb;
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/blog_detail');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function blogCategory($slug) {
        $blog_cat_id = $this->common_model->getSingleFieldFromAnyTable('bg_cat_id', 'slug', $slug, $this->blog->tableCategoryName);
        $data['blog_data'] = $this->blog->getBlogByCategoryId($blog_cat_id);
        $data['blog_category_id'] = $blog_cat_id;
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/blog');
        $this->load->view($this->config->item('template') . '/footer');
    }

    public function blogArchive($add_time) {
        $data['blog_data'] = $this->blog->getBlogArchives($add_time);
        $data['blog_archive'] = $add_time;
        $this->load->view($this->config->item('template') . '/header', $data);
        $this->load->view($this->config->item('template') . '/blog');
        $this->load->view($this->config->item('template') . '/footer');
    }

}