<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Province extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/province_model', 'province');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['province_data'] = $this->province->getProvinceList();
        $data['breadcum'] = 'Manage Province';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/province/province_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {

        if (!empty($_POST)) {

            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_name', 'Province Name', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["province_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/province_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('province_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->province->add($detail['upload_data']['file_name']);
                $this->session->set_flashdata('ProvinceSuccess', 'Province Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/province-list');
                exit;
            } else {
                $data['country_id'] = $this->input->post('country_id');
                $data['province_name'] = $this->input->post('province_name');
                $data['province_description'] = $this->input->post('province_description');
                $data['hours'] = $this->input->post('hours');
                $data['iframe_code'] = $this->input->post('iframe_code');
                $data['province_image'] = $this->input->post('province_image');
                $data['province_email_id'] = $this->input->post('province_email_id');
                $data['telephone'] = $this->input->post('telephone');
                $data['address'] = $this->input->post('address');
                $data['copyright_text'] = $this->input->post('copyright_text');
                $data['gst'] = $this->input->post('gst');
                $data['pst'] = $this->input->post('pst');
                $data['hst'] = $this->input->post('hst');
            }
        }
        $data['country_list'] = $this->province->getCountryList();
        $data['breadcum'] = 'Add Province';

        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/province/province_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($provinceId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_name', 'Province Name', 'trim|required');

            if ($this->form_validation->run()) {
                if ($_FILES["province_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/province_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('province_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->province->update($provinceId, $detail['upload_data']['file_name']);
                $this->session->set_flashdata('ProvinceSuccess', 'Province Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/province-list');
                exit;
            } else {
                $data['country_id'] = $this->input->post('country_id');
                $data['province_name'] = $this->input->post('province_name');
                $data['province_description'] = $this->input->post('province_description');
                $data['hours'] = $this->input->post('hours');
                $data['iframe_code'] = $this->input->post('iframe_code');
                $data['province_image'] = $this->input->post('province_image');
                $data['province_email_id'] = $this->input->post('province_email_id');
                $data['telephone'] = $this->input->post('telephone');
                $data['address'] = $this->input->post('address');
                $data['copyright_text'] = $this->input->post('copyright_text');
                $data['gst'] = $this->input->post('gst');
                $data['pst'] = $this->input->post('pst');
                $data['hst'] = $this->input->post('hst');
            }
        } else {
            $data['lists'] = $lists = $this->province->getProvinceListById($provinceId);
            $data['country_list'] = $country_list = $this->province->getCountryList();
            $data['province_id'] = $provinceId;
            $data['country_id'] = $lists['country_id'];
            $data['province_name'] = $lists['province_name'];
            $data['province_description'] = $lists['province_description'];
            $data['hours'] = $lists['hours'];
            $data['iframe_code'] = $lists['iframe_code'];
            $data['province_image'] = $lists['province_image'];
            $data['province_email_id'] = $lists['province_email_id'];
            $data['telephone'] = $lists['telephone'];
            $data['address'] = $lists['address'];
            $data['copyright_text'] = $lists['copyright_text'];
            $data['gst'] = $lists['gst'];
            $data['pst'] = $lists['pst'];
            $data['hst'] = $lists['hst'];
        }

        $data['breadcum_edit'] = 'Edit Province';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/province/province_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($provinceId, $action) {
        if ($provinceId != '') {
            $this->province->updateStatus($provinceId, $action);
            $this->session->set_flashdata('ProvinceSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/province-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/leftbar');
        $this->load->view($this->config->item('adminFolder') . '/province/province_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function set_language($provinceId, $action) {
        if ($provinceId != '') {
            if ($action == 'yes') {
                $languageData = $this->province->updateDefaultLanguage($provinceId, $action);
                $defaultLanguageData = $this->province->updateDefault($provinceId, 'no');
                redirect('admin/province-list');
                exit;
            }
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/leftbar');
        $this->load->view($this->config->item('adminFolder') . '/province/province_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($provinceId) {
        if (isset($provinceId) && $provinceId != '') {
            $this->province->delete($provinceId);
            $this->session->set_flashdata('ProvinceSuccess', 'Province Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/province-list');
            exit;
        }
    }

    public function getProvinceData() {
        $country_id = $this->input->post('country_id');
        $data['province_list'] = $province_list = $this->province->getProvinceListByCountry($country_id);
        $data['success'] = true;
        if (sizeof($province_list) == 0) {
            $data['success'] = false;
        }
        echo json_encode($data);
        die;
    }

    public function getProvinceRecords() {
        $country_id = $this->input->post('country_id');
        $data['province_list'] = $province_list = $this->province->getProvinceListByCountry($country_id);
        $data['success'] = true;
        if (sizeof($province_list) == 0) {
            $data['success'] = false;
        }
        echo json_encode($data);
        die;
    }

    public function deleteImage($imageId) {
        $image_name = $this->common_model->getSingleFieldFromAnyTable('image_name', 'p_img_id', $imageId, 'tbl_province_images');
        if (isset($imageId) && $imageId != '') {
            unlink('assets/uploads/province_images/' . $imageId . '/' . $image_name);
            $this->province->deleteProvinceImagesById($imageId);
            $msg = 'Image Deleted';
            echo json_encode($msg);
        }
    }

    public function managePictures($provinceId) {
        $data['provinceData'] = $provinceData = $this->province->getProvinceListById($provinceId);
        $data['image_data'] = $this->province->getProvinceImagesById($provinceId);
        $data['breadcum'] = $provinceData['province_name'] . ' Pictures #' . $provinceData['province_id'];

        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/province/manage_pictures');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function uploadImages($provinceId) {
        if (!empty($_FILES)) {

            @mkdir("assets/uploads/province_images/" . $provinceId, 0777, true);
            @chmod("assets/uploads/province_images/" . $provinceId, 0777);
            $temp = true;
            $config['upload_path'] = 'assets/uploads/province_images/' . $provinceId;
            $config['allowed_types'] = 'gif|jpg|png|jpeg';
            $this->load->library('upload', $config);
            if ($_FILES['file']['name'] != '') {
                if (!$this->upload->do_upload('file')) {
                    $output['error'] = array('error' => $this->upload->display_errors());
                    $temp = false;
                } else {
                    $data = array('upload_data' => $this->upload->data());
                }
            }
            if ($temp) {
                $this->province->addProvinceImage($provinceId, $data['upload_data']['file_name']);
                $data = 'done';
                $this->output
                        ->set_content_type('application/json')
                        ->set_output(json_encode($data));
            }
        }
    }

    public function setImageOrder() {
        if (!empty($_GET)) {
            $updateRecordsArray = $this->input->get('recordsArray');
            $listingCounter = 1;
            foreach ($updateRecordsArray as $recordIDValue) {
                $this->db->query("update tbl_province_images set display_order = " . $listingCounter . " where p_img_id = " . $recordIDValue);
                $listingCounter = $listingCounter + 1;
            }
        }
    }

}
