<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package_Item extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder').'/package_item_model', 'pkgItem');    
        $this->load->model($this->config->item('adminFolder').'/package_model', 'package');    
        $this->load->library('form_validation');       
    }

    public function index() {
        $data['item_data'] = $this->pkgItem->getPackageItemList();     
        $data['breadcum'] = 'Manage Menu Item';
        
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/package_item/package_item_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function add() { 
        if (!empty($_POST)) {
     
            $this->form_validation->set_rules('category_id', 'category', 'trim|required');
            $this->form_validation->set_rules('item_name', 'Item Name', 'trim|required');
            $this->form_validation->set_rules('price', 'Item price', 'trim|required');   
            
            if ($this->form_validation->run()) {                
                $this->pkgItem->add();                
                $this->session->set_flashdata('CateringItemSuccess','Catering Item Has Been Added Successfully');  
                redirect($this->config->item('adminFolder').'/package-item-list');
                exit;
            }else{            
                
                $data['category_id'] = $this->input->post('category_id');
                $data['item_name'] = $this->input->post('item_name');
                $data['item_code'] = $this->input->post('item_code');
            }            
        }                   
                $data['breadcum'] = 'Add Menu Item';       
                $data['category_data'] = $this->pkgItem->getPackageCategoryList();
         
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/package_item/package_item_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function edit($pkgItemId) { 
        if (!empty($_POST)) {  
           // pr($_POST);die;
       
            $this->form_validation->set_rules('category_id', 'category', 'trim|required');
            $this->form_validation->set_rules('item_name', 'Item Name', 'trim|required');
            $this->form_validation->set_rules('price', 'Item price', 'trim|required');   

            if ($this->form_validation->run()) {
               
                $this->pkgItem->update($pkgItemId);             
                $this->session->set_flashdata('CateringItemSuccess','Catering Item Has Been Updated Successfully');
                redirect($this->config->item('adminFolder').'/package-item-list');
                exit;
            }else{
         
                $data['category_id'] = $this->input->post('category_id');
                $data['item_name'] = $this->input->post('item_name');
                $data['item_code'] = $this->input->post('item_code');
            }            
        }else{            
            $result = $this->pkgItem->getPackageItemsById($pkgItemId);    
            $data['pkg_item_id'] = $pkgItemId;      
  
            $data['category_id'] = $result['category_id'];
            $data['item_name'] = $result['item_name'];
            $data['price'] = $result['price']; 
        }    
            $data['breadcum_edit'] = 'Edit Menu Item';   
            $data['category_data'] = $this->pkgItem->getPackageCategoryList();
		
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/package_item/package_item_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function approve($pkgItemId, $status) {
        if ($pkgItemId != '') {
            $this->pkgItem->updateStatus($pkgItemId, $status);
            $this->session->set_flashdata('CateringItemSuccess','Status Of This Record Has Been Updated Successfully');  
            redirect($this->config->item('adminFolder').'/package-item-list');
            exit;
        }        
       $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/package_item/package_item_form');
        $this->load->view($this->config->item('adminFolder').'/footer');
    }

    public function delete($pkgItemId) {       
        if (isset($pkgItemId) && $pkgItemId != '') {     
            $this->pkgItem->delete($pkgItemId);
             $this->session->set_flashdata('CateringItemSuccess','Catering Item Has Been Deleted Successfully');     
            redirect($this->config->item('adminFolder').'/package-item-list');
            exit;
        }
    }
}