<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Package_Category extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/package_category_model', 'PackageCat');
        $this->load->model($this->config->item('adminFolder').'/country_model', 'country');
        $this->load->model($this->config->item('adminFolder').'/province_model', 'province');
        $this->load->library('form_validation');       
    }

    public function index() {  
        $data['category_data'] = $this->PackageCat->getCategoryList();  
        $data['breadcum'] = 'Manage Category';     
   
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/package_category/package_category_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }    

    public function add() {  
        
        if (!empty($_POST)) {      
            $this->form_validation->set_rules('pkg_cat_name', 'Catering Category Name', 'trim|required');        
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) { 
                
                $this->PackageCat->add();
                $this->session->set_flashdata('PkgCatSuccess', 'Package Category Has Been Added Successfully');
                redirect($this->config->item('adminFolder').'/package-category-list');
                exit;
            }else{
                $data['pkg_cat_name'] = $this->input->post('pkg_cat_name');              
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');               
            }
        }
                
                $data['breadcum'] = 'Add Category';            
                $data['country_list'] = $this->country->getCountryList();                
     
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/package_category/package_category_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }  
 

    public function edit($pkgCatId) { 
        if (!empty($_POST)) {      
            $this->form_validation->set_rules('pkg_cat_name', 'Package Category Name', 'trim|required');        
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {                
                $this->PackageCat->update($pkgCatId);       
                $this->session->set_flashdata('PkgCatSuccess', 'Package Category Has Been Updated Successfully');
                redirect($this->config->item('adminFolder').'/package-category-list');                 
                exit;
            }else{
                $data['pkg_cat_name'] = $this->input->post('pkg_cat_name');              
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');                 
            }
        }
            $result = $this->PackageCat->getCategoryById($pkgCatId);      
            
          
            $data['pkg_cat_id'] = $pkgCatId;
            $data['pkg_cat_name'] = $result['pkg_cat_name'];            
            $data['country_id'] = $country_id = $result['country_id'];
            $data['province_id'] = $lists['province_id']; 
            $data['country_list'] = $this->country->getCountryList();         
            $data['province_list'] = $this->province->getProvinceListByCountry($country_id); 
            $data['breadcum_edit'] = 'Edit Category';            
        
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/package_category/package_category_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($pkgCatId, $status) {
        if ($pkgCatId != '') {
             $this->PackageCat->updateStatus($pkgCatId, $status);
            $this->session->set_flashdata('PkgCatSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder').'/package-category-list/');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/package_category/package_category_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($pkgCatId) {    
        if (isset($pkgCatId) && $pkgCatId != '') { 
            $this->PackageCat->delete($pkgCatId);
            $this->session->set_flashdata('PkgCatSuccess', 'Package Category Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder').'/package-category-list/');
            exit;
        }
    }

}
