<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Menu_Category extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/menu_category_model', 'menuCat');
        $this->load->model($this->config->item('adminFolder').'/country_model', 'country');
        $this->load->model($this->config->item('adminFolder').'/province_model', 'province');
      
        $this->load->library('form_validation');
        $this->location_id = $this->session->userdata('location_id');
    }

    public function index() {     
        $data['category_data'] = $this->menuCat->getCategoryList();      
        $data['page_name'] = 'MenuItemCategory';
        $data['breadcum'] = 'Manage Category'; 
        
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/menu_category/menu_category_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }    

    public function add() {  
        
        if (!empty($_POST)) {             
           $item_cat_name = $this->input->post('item_cat_name');            
            $this->form_validation->set_rules('item_cat_name', 'Menu Category Name', 'trim|required');        
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) { 
                 if ($_FILES["item_cat_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/menu_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('item_cat_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->menuCat->add($item_cat_name,$detail['upload_data']['file_name']);
                $this->session->set_flashdata('MenuCategorySuccess', 'Menu Category Has Been Added Successfully');
                redirect($this->config->item('adminFolder').'/menu-category-list');
                exit;
            }else{
                $data['item_cat_name'] = $menu_cat_name = $this->input->post('item_cat_name');
                $data['item_cat_description'] = $this->input->post('item_cat_description');
                $data['item_cat_image'] = $this->input->post('item_cat_image');
                $data['meta_title'] = $this->input->post('meta_title');
                $data['meta_keywords'] = $this->input->post('meta_keywords');
                $data['meta_description'] = $this->input->post('meta_description');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');               
            }
        }
             
                $data['breadcum'] = 'Add Category';            
                $data['country_list'] = $this->country->getCountryList();               
     
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/menu_category/menu_category_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }  
 

    public function edit($menuCatId) { 
        if (!empty($_POST)) {
        //    pr($_POST);die;
            $this->form_validation->set_rules('item_cat_name', 'Menu Category Name', 'trim|required');        
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');

            if ($this->form_validation->run()) {
                 if ($_FILES["item_cat_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/menu_item_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('item_cat_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->menuCat->update($menuCatId, $detail['upload_data']['file_name']);       
                $this->session->set_flashdata('MenuCategorySuccess', 'Menu Category Has Been Updated Successfully');
                redirect($this->config->item('adminFolder').'/menu-category-list');                 
                exit;
            }else{
                $data['item_cat_name'] = $this->input->post('item_cat_name');
                $data['item_cat_description'] = $this->input->post('item_cat_description');
                $data['item_cat_image'] = $this->input->post('item_cat_image');
                $data['meta_title'] = $this->input->post('meta_title');
                $data['meta_keywords'] = $this->input->post('meta_keywords');
                $data['meta_description'] = $this->input->post('meta_description');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');                 
            }
        }
            $result = $this->menuCat->getCategoryById($menuCatId);              
            $data['menucat_id'] = $menuCatId;
            $data['item_cat_name'] = $result['item_cat_name'];
            $data['item_cat_description'] = $result['item_cat_description'];
            $data['item_cat_image'] = $result['item_cat_image'];
            $data['meta_title'] = $result['meta_title'];
            $data['meta_keywords'] = $result['meta_keywords'];
            $data['meta_description'] = $result['meta_description'];
            $data['country_id'] = $country_id = $result['country_id'];
            $data['province_id'] = $lists['province_id']; 
            $data['country_list'] = $this->country->getCountryList();         
            $data['province_list'] = $this->province->getProvinceListByCountry($country_id);  
        
            $data['breadcum_edit'] = 'Edit Category';            
        
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/menu_category/menu_category_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($menuCatId, $status) {
        if ($menuCatId != '') {
             $this->menuCat->updateStatus($menuCatId, $status);
            $this->session->set_flashdata('MenuCategorySuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder').'/menu-category-list/');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/menu_category/menu_category_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($menuCatId) {    
        if (isset($menuCatId) && $menuCatId != '') { 
            $this->menuCat->delete($menuCatId);
            $this->session->set_flashdata('MenuCategorySuccess', 'Menu Category Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder').'/menu-category-list/');
            exit;
        }
    }

}
