<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Meals extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/package_model', 'package');
        $this->load->model($this->config->item('adminFolder') . '/online_category_model', 'onlineCat');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['package_data'] = $this->package->getPackageList('meal');
        $data['breadcum'] = 'Manage Meal';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/meals/meal_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('name', 'Package Title', 'trim|required');
            $this->form_validation->set_rules('price', 'Price', 'trim|required');
            $this->form_validation->set_rules('min_order_amount', 'Minimum Order Amount', 'trim|required');
            $this->form_validation->set_rules('online_cat_id', 'Category', 'trim|required');
            //   $this->form_validation->set_rules('description', 'Package Description', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["meal_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/meal_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('meal_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->package->addPackage('meal',$detail['upload_data']['file_name']);
                $this->session->set_flashdata('PackageSuccess', 'Package Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/meal-list');
                exit;
            } else {
                $data['name'] = $this->input->post('name');
                $data['price'] = $this->input->post('price');
                $data['min_order_amount'] = $this->input->post('min_order_amount');
                $data['description'] = $this->input->post('description');
                $data['online_cat_id'] = $this->input->post('online_cat_id');
            }
        }
        $data['breadcum'] = 'Add Meal';
        $data['child_categories'] = $this->onlineCat->getChildCategories(1);
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/meals/meal_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($packageId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('name', 'Package Title', 'trim|required');
            $this->form_validation->set_rules('price', 'Price', 'trim|required');
            $this->form_validation->set_rules('min_order_amount', 'Minimum Order Amount', 'trim|required');
            $this->form_validation->set_rules('online_cat_id', 'Category', 'trim|required');
            // $this->form_validation->set_rules('description', 'Package Description', 'trim|required');
            if ($this->form_validation->run()) {
                if ($_FILES["meal_image"]['name']) {
                    $config['upload_path'] = './assets/uploads/meal_images';
                    $config['allowed_types'] = 'jpg|png|jpeg|gif';
                    $this->load->library('upload', $config);
                    if (!$this->upload->do_upload('meal_image')) {
                        $error_msg = $this->upload->display_errors();
                    } else {
                        $detail = array('upload_data' => $this->upload->data());
                    }
                }
                $this->package->update($packageId,$detail['upload_data']['file_name']);
                $this->session->set_flashdata('PackageSuccess', 'Package Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/meal-list');
                exit;
            } else {
                $data['name'] = $this->input->post('name');
                $data['price'] = $this->input->post('price');
                $data['min_order_amount'] = $this->input->post('min_order_amount');
                $data['description'] = $this->input->post('description');
                $data['online_cat_id'] = $this->input->post('online_cat_id');
            }
        } else {
            $lists = $this->package->getPackageListById($packageId);
            $data['package_id'] = $packageId;
            $data['name'] = $lists['name'];
            $data['price'] = $lists['price'];
            $data['min_order_amount'] = $lists['min_order_amount'];
            $data['meal_image'] = $lists['package_image'];
            $data['description'] = $lists['description'];
            $data['online_cat_id'] = $lists['online_cat_id'];
        }
        $data['breadcum_edit'] = 'Edit Meal';
        $data['child_categories'] = $this->onlineCat->getChildCategories(1);
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/meals/meal_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function packageSpecifications($packageId) {
        if (!empty($_POST)) {
            $this->package->deleteSpecificationsByPackageId($packageId);
            $this->package->addPackageSpecifications($packageId);
            $this->session->set_userdata('pkg_success_msg', 'Package Specifications Has Been Updated Successfully');
            redirect('admin/meal-specification/' . $packageId);
            exit;
        } else {
            $data['packageId'] = $packageId;
            $data['breadcum'] = 'Manage Meal Specifications';
            $data['package_category'] = $this->package->getPackageCategoryList();
            $data['packg_item'] = $this->package->getPackageItemList();
            $data['specificationList'] = $this->package->getPackageSpecificationList($packageId);
            $this->load->view($this->config->item('adminFolder') . '/header', $data);
            $this->load->view($this->config->item('adminFolder') . '/meals/meal_specification');
            $this->load->view($this->config->item('adminFolder') . '/footer');
        }
    }

    public function approve($packageId, $status) {
        if ($packageId != '') {
            $this->package->updateStatus($packageId, $status);
            $this->session->set_flashdata('PackageSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/meal-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/meals/meal_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($packageId) {
        if (isset($packageId) && $packageId != '') {
            $this->package->delete($packageId);
            $this->session->set_flashdata('PackageSuccess', 'Package Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/meal-list');
            exit;
        }
    }

    public function deleteSpecification($specificId, $package_id) {
        if (isset($specificId) && $specificId != '') {
            $this->package->deleteSpecifications($specificId);
            $this->session->set_flashdata('PackageSuccess', 'Package Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/meal-specification/' . $package_id);
            exit;
        }
    }

    public function getPackageItemList() {
        $category_id = $this->input->post('category_id');
        $data['package_item'] = $package_item = $this->package->getItemsByPackageCat($category_id);

        $data['success'] = true;
        if (sizeof($package_item) == 0) {
            $data['success'] = false;
        }
        echo json_encode($data);
        die;
    }

}
