<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Email_Template extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/email_template_model', 'template');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['template_data'] = $this->template->getEmailTemplateList();
        $data['breadcum'] = 'Manage Email Template';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/email_template/email_template_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('email_from_name', 'Email From Name', 'trim|required');
            $this->form_validation->set_rules('sender_from_email', 'Sender From Email', 'trim|required');
            $this->form_validation->set_rules('email_template_title', 'Email Template Title', 'trim|required');
            $this->form_validation->set_rules('email_subject', 'Email Subject', 'trim|required');
            $this->form_validation->set_rules('template_description', 'Template Description', 'trim|required');
            if ($this->form_validation->run()) {
                $this->template->add();
                $this->session->set_flashdata('TemplateSuccess', 'Email Template Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/email-template-list');
                exit;
            } else {
                $data['email_from_name'] = $this->input->post('email_from_name');
                $data['sender_from_email'] = $this->input->post('sender_from_email');
                $data['sender_to_email'] = $this->input->post('sender_to_email');
                $data['email_template_title'] = $this->input->post('email_template_title');
                $data['email_subject'] = $this->input->post('email_subject');
                $data['template_description'] = $this->input->post('template_description');
            }
        }

        $data['breadcum'] = 'Add Email Template';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/email_template/email_template_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($templateId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('email_from_name', 'Email From Name', 'trim|required');
            $this->form_validation->set_rules('sender_from_email', 'Sender From Email', 'trim|required');
            $this->form_validation->set_rules('email_template_title', 'Email Template Title', 'trim|required');
            $this->form_validation->set_rules('email_subject', 'Email Subject', 'trim|required');
            $this->form_validation->set_rules('template_description', 'Template Description', 'trim|required');
            if ($this->form_validation->run()) {
                $this->template->update($templateId);
                $this->session->set_flashdata('TemplateSuccess', 'Email Template Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/email-template-list');
                exit;
            } else {
                $data['email_from_name'] = $this->input->post('email_from_name');
                $data['sender_from_email'] = $this->input->post('sender_from_email');
                $data['sender_to_email'] = $this->input->post('sender_to_email');
                $data['email_template_title'] = $this->input->post('email_template_title');
                $data['email_subject'] = $this->input->post('email_subject');
                $data['template_description'] = $this->input->post('template_description');
            }
        } else {
            $lists = $this->template->getEmailTemplateById($templateId);
            $data['template_id'] = $templateId;
            $data['email_from_name'] = $lists['email_from_name'];
            $data['sender_from_email'] = $lists['sender_from_email'];
            $data['sender_to_email'] = $lists['sender_to_email'];
            $data['email_template_title'] = $lists['email_template_title'];
            $data['email_subject'] = $lists['email_subject'];
            $data['template_description'] = $lists['template_description'];
        }
        $data['breadcum'] = 'Edit Template';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/email_template/email_template_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($templateId, $status) {
        if ($templateId != '') {
            $this->template->updateStatus($templateId, $status);
            $this->session->set_flashdata('TemplateSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/email-template-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/email_template/email_template_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($templateId) {
        if (isset($templateId) && $templateId != '') {
            $this->template->delete($templateId);
            $this->session->set_flashdata('TemplateSuccess', 'Email Template Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/email-template-list');
            exit;
        }
    }

}