<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Delivery_Charge extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/delivery_charge_model', 'charges');
        $this->load->model($this->config->item('adminFolder') . '/country_model', 'country');
        $this->load->model($this->config->item('adminFolder') . '/province_model', 'province');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['delivery_charges'] = $this->charges->getDeliveryChargeList();
        $data['breadcum'] = 'Manage Delivery Charges';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/delivery_charges/delivery_charges_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('area_name', 'Area Name', 'trim|required');
            $this->form_validation->set_rules('area_pincode', 'Area Pincode', 'trim|required');
            $this->form_validation->set_rules('charges', 'Charges', 'trim|required');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');
            if ($this->form_validation->run()) {
                $this->charges->add();
                $this->session->set_flashdata('ChargesSuccess', 'Delivery Charge Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/area-list');
                exit;
            } else {
                $data['area_name'] = $this->input->post('area_name');
                $data['area_pincode'] = $this->input->post('area_pincode');
                $data['charges'] = $this->input->post('charges');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
                $data['province_list'] = $this->province->getProvinceListByCountry($this->input->post('country_id'));
            }
        }
        $data['breadcum'] = 'Add Delivery Charges';
        $data['country_list'] = $this->country->getCountryList();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/delivery_charges/delivery_charges_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($areaId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('area_name', 'Area Name', 'trim|required');
            $this->form_validation->set_rules('area_pincode', 'Area Pincode', 'trim|required');
            $this->form_validation->set_rules('charges', 'Charges', 'trim|required');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');
            if ($this->form_validation->run()) {
                $this->charges->update($areaId);
                $this->session->set_flashdata('ChargesSuccess', 'Delivery Charge Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/area-list');
                exit;
            } else {
                $data['area_name'] = $this->input->post('area_name');
                $data['area_pincode'] = $this->input->post('area_pincode');
                $data['charges'] = $this->input->post('charges');
                $data['country_id'] = $country_id = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
            }
        } else {
            $lists = $this->charges->getDeliveryChargeListByArea($areaId);
            $data['area_id'] = $lists['area_id'];
            $data['area_name'] = $lists['area_name'];
            $data['area_pincode'] = $lists['area_pincode'];
            $data['charges'] = $lists['charges'];
            $data['country_id'] = $country_id = $lists['country_id'];
            $data['province_id'] = $lists['province_id'];
        }
        $data['country_list'] = $this->country->getCountryList();
        $data['province_list'] = $this->province->getProvinceListByCountry($country_id);
        $data['breadcum'] = 'Edit Delivery Charges';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/delivery_charges/delivery_charges_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($areaId, $status) {
        if ($areaId != '') {
            $this->charges->updateStatus($areaId, $status);
            $this->session->set_flashdata('ChargesSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/area-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/delivery_charges/delivery_charges_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($areaId) {
        if (isset($areaId) && $areaId != '') {
            $this->charges->delete($areaId);
            $this->session->set_flashdata('ChargesSuccess', 'Delivery Charge Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/area-list');
            exit;
        }
    }

}