<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Coupon extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/coupon_model', 'coupon');
        $this->load->model($this->config->item('adminFolder') . '/country_model', 'country');
        $this->load->model($this->config->item('adminFolder') . '/province_model', 'province');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['coupon_data'] = $this->coupon->getCouponList();
        $data['breadcum'] = 'Manage Coupon';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/coupon/coupon_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {

        if (!empty($_POST)) {
            $this->form_validation->set_rules('coupon_code', 'Coupon Code', 'trim|required');
            $this->form_validation->set_rules('coupon_price', 'Coupon Text', 'trim|required');
            $this->form_validation->set_rules('minimum_order_amount', 'Minimum Order Amount', 'trim|required');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');
            $this->form_validation->set_rules('expiration_date', 'Expiration Date', 'trim|required');

            if ($this->form_validation->run()) {
                $this->coupon->add();
                $this->session->set_flashdata('CouponSuccess', 'Coupon Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/coupon-list');
                exit;
            } else {
                $data['coupon_code'] = $this->input->post('coupon_code');
                $data['coupon_price'] = $this->input->post('coupon_price');
                $data['minimum_order_amount'] = $this->input->post('minimum_order_amount');
                $data['coupon_type'] = $this->input->post('coupon_type');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
                $data['expiration_date'] = $this->input->post('expiration_date');
            }
        }

        $data['breadcum'] = 'Add Coupon';
        $data['country_list'] = $this->country->getCountryList();
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/coupon/coupon_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($couponId) {

        if (!empty($_POST)) {
            $this->form_validation->set_rules('coupon_code', 'Coupon Code', 'trim|required');
            $this->form_validation->set_rules('coupon_price', 'Coupon Text', 'trim|required');
            $this->form_validation->set_rules('minimum_order_amount', 'Minimum Order Amount', 'trim|required');
            $this->form_validation->set_rules('country_id', 'Country', 'trim|required');
            $this->form_validation->set_rules('province_id', 'Province', 'trim|required');
            $this->form_validation->set_rules('expiration_date', 'Expiration Date', 'trim|required');

            if ($this->form_validation->run()) {
                $this->coupon->update($couponId);
                $this->session->set_flashdata('CouponSuccess', 'Coupon Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/coupon-list');
                exit;
            } else {
                $data['coupon_code'] = $this->input->post('coupon_code');
                $data['coupon_price'] = $this->input->post('coupon_price');
                $data['minimum_order_amount'] = $this->input->post('minimum_order_amount');
                $data['coupon_type'] = $this->input->post('coupon_type');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
                $data['expiration_date'] = $this->input->post('expiration_date');
            }
        }
        $lists = $this->coupon->getCouponListById($couponId);
        $data['country_id'] = $country_id = $lists['country_id'];
        $data['country_list'] = $this->country->getCountryList();
        $data['province_list'] = $this->province->getProvinceListByCountry($country_id);
        $data['coupon_id'] = $couponId;
        $data['coupon_code'] = $lists['coupon_code'];
        $data['coupon_price'] = $lists['coupon_price'];
        $data['minimum_order_amount'] = $lists['minimum_order_amount'];
        $data['coupon_type'] = $lists['coupon_type'];
        $data['country_id'] = $lists['country_id'];
        $data['province_id'] = $lists['province_id'];
        $data['expiration_date'] = $lists['expiration_date'];
        $data['breadcum_edit'] = 'Edit Coupon';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/coupon/coupon_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($couponId, $status) {
        if ($couponId != '') {
            $this->coupon->updateStatus($couponId, $status);
            $this->session->set_flashdata('CouponSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/coupon-list');
            exit;
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/coupon/coupon_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function delete($couponId) {
        if (isset($couponId) && $couponId != '') {
            $this->coupon->delete($couponId);
            $this->session->set_flashdata('CouponSuccess', 'Coupon Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/coupon-list');
            exit;
        }
    }

}