<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Content extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/content_model', 'content');
        $this->load->model($this->config->item('adminFolder') . '/country_model', 'country');
        $this->load->model($this->config->item('adminFolder') . '/province_model', 'province');
        $this->load->library('form_validation');
    }

    public function index() {
        $data['content_data'] = $this->content->getContentList();
        $data['breadcum'] = 'Manage Content';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/content/content_list');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function add() {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('page_title', 'Page Name', 'trim|required');
            $this->form_validation->set_rules('page_heading', 'Page Heading', 'trim|required');
            $this->form_validation->set_rules('page_content', 'Page Content', 'trim|required');
            if ($this->form_validation->run()) {
                $this->content->addContent();
                $this->session->set_flashdata('ContentSuccess', 'Page Detail Has Been Added Successfully');
                redirect($this->config->item('adminFolder') . '/content-list');
                exit;
            } else {
                $data['page_title'] = $this->input->post('page_title');
                $data['page_heading'] = $this->input->post('page_heading');
                $data['page_url'] = $this->input->post('page_url');
                $data['page_content'] = $this->input->post('page_content');
                $data['content_type'] = $this->input->post('content_type');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
            }
        }
        $data['parent_list'] = $this->content->getParentPageRecords();
        $data['country_list'] = $this->country->getCountryList();
        $data['breadcum'] = 'Add Content';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/content/content_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function edit($contentId) {
        if (!empty($_POST)) {
            $this->form_validation->set_rules('page_title', 'Page Name', 'trim|required');
            $this->form_validation->set_rules('page_content', 'Page Content', 'trim|required');
            if ($this->form_validation->run()) {
                $this->content->updateContent($contentId);
                $this->session->set_flashdata('ContentSuccess', 'Page Content Has Been Updated Successfully');
                redirect($this->config->item('adminFolder') . '/content-list');
                exit;
            } else {
                $data['page_title'] = $this->input->post('page_title');
                $data['page_heading'] = $this->input->post('page_heading');
                $data['page_content'] = $this->input->post('page_content');
                $data['content_type'] = $this->input->post('content_type');
                $data['country_id'] = $this->input->post('country_id');
                $data['province_id'] = $this->input->post('province_id');
            }
        }
        $data['parent_list'] = $this->content->getParentPageRecords();
        $lists = $this->content->getContentListById($contentId);
        $data['page_id'] = $lists['page_id'];
        $data['page_title'] = $lists['page_title'];
        $data['slug'] = $lists['slug'];
        $data['page_heading'] = $lists['page_heading'];
        $data['page_content'] = $lists['page_content'];
        $data['content_type'] = $lists['content_type'];
        $data['country_id'] = $country_id = $lists['country_id'];
        $data['province_id'] = $lists['province_id'];
        $data['country_list'] = $this->country->getCountryList();
        $data['province_list'] = $this->province->getProvinceListByCountry($country_id);
        $data['breadcum_edit'] = 'Edit Content';
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/content/content_form');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

    public function approve($contentId, $action) {
        if ($contentId != '') {
            $data = $this->content->updateStatus($contentId, $action);
            $this->session->set_flashdata('ContentSuccess', 'Status Of This Record Has Been Updated Successfully');
            redirect($this->config->item('adminFolder') . '/content-list');
            exit;
        }
    }

    public function delete($contentId) {
        if (isset($contentId) && $contentId != '') {
            $this->content->delete($contentId);
            $this->session->set_flashdata('ContentSuccess', 'Content Has Been Deleted Successfully');
            redirect($this->config->item('adminFolder') . '/content-list');
            exit;
        }
    }

}