<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class change_Password extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder') . '/change_password_model', 'changepassword');
        $this->admin_id = $this->session->userdata('admin_id');
    }

    public function index() {
        $data['breadcum'] = "Change Password";
        if (!empty($_POST)) {
            $this->form_validation->set_rules('old_pass', 'Old Password', 'trim|required');
            $this->form_validation->set_rules('new_pass', 'New Password', 'trim|required|min_length[3]|max_length[15]');
            $this->form_validation->set_rules('re_password', 'Confirm Password', 'trim|required|min_length[3]|max_length[15]|matches[new_pass]');

            if ($this->form_validation->run()) {
                $checkpass = $this->changepassword->checkOldPassword($this->admin_id);
                if ($checkpass) {
                    $this->changepassword->updatePassword();
                    $this->session->set_flashdata('successmsg', 'Password Updation Successful');
                    redirect($this->config->item('adminFolder') . '/change-password');
                    exit;
                } else {
                    $this->session->set_flashdata('errormsg', 'Current Password is Wrong');
                    redirect($this->config->item('adminFolder') . '/change-password');
                    exit;
                }
                redirect($this->config->item('adminFolder') . '/logout');
                exit;
            }
        }
        $this->load->view($this->config->item('adminFolder') . '/header', $data);
        $this->load->view($this->config->item('adminFolder') . '/change_password');
        $this->load->view($this->config->item('adminFolder') . '/footer');
    }

}
