<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Blogcomment extends CI_Controller {

    public function __construct() {
        parent::__construct();       
        $this->common_model->checkAdminLogin();
        $this->load->model($this->config->item('adminFolder').'/blog_comment_model', 'comment');              
        $this->load->library('form_validation');        
    }

   
    public function index($commentId) {  
        $data['comment_data'] = $this->comment->getBlogCommentList($commentId);      
        $data['page_name'] = 'BlogComment';
        $data['breadcum'] = 'Manage Blog Comment';
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/blog/blog_comment_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
                
    } 
    
    public function commentList() {        
        
        $data['comment_data'] = $this->comment->getCommentRecords();    
        $data['page_name'] = 'BlogComment';
        $data['breadcum'] = 'Manage Blog Comment';
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/blog/blog_comment_list');
        $this->load->view($this->config->item('adminFolder').'/footer');
                
    } 
    
    public function approve($commentId,$status){ 
                if($commentId!=''){                              
                            $commentData = $this->comment->updateStatus($commentId,$status);
                            redirect($this->config->item('adminFolder').'/blog-comment');
                            exit;           
                        }       
        $this->load->view($this->config->item('adminFolder').'/header', $data);       
        $this->load->view($this->config->item('adminFolder').'/blog/blog_comment_list');
        $this->load->view($this->config->item('adminFolder').'/footer');      
    }
   
    public function delete($commentId){
        if(isset($commentId) && $commentId != ''){
         $this->comment->delete($commentId);
            $this->session->set_flashdata('message', show_message('Blogger Comment Has Been Removed Successfully', 'success'));
            redirect($this->config->item('adminFolder').'/blog-comment');
        exit;        
        }        
    }    
}