<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1><?php echo $page_heading ?></h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active"><?php echo $page_heading ?></li>
        </ol>
    </div>
</section>  
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <div class="well_success text-success text-center bold">
            <?php if ($order_data['order_status'] == 'pending') { ?>
                <div class="alert alert-success" role="alert">Thanking for Ordering with us , We have received your Order. Your order confirmation has been sent to your email id.</div>
            <?php } else if ($order_data['order_status'] == 'cancelled') { ?>
                <div class="alert alert-danger" role="alert">Opps...Looks like there some issue with payment, Please try again. !!</div>
            <?php } ?>
            <?php echo str_replace("{#order_id}", 'A1-' . $order_data['order_id'], $page_content); ?>
        </div>
        <hr class="clearfix">
        <div class="row">
            <div class="col-md-8">
                <h3 class="side-heading">Ordered Items Detail</h3>
                <table class="table order-table table-bordered">
                    <tr>
                        <th>Item Name</th>
                        <th>Qty.</th>
                        <th>Unit</th>
                        <th align="right">Price</th>
                        <th>Total Price</th>
                    </tr>
                    <?php
                    foreach ($order_items_data as $order_items) {
                        ?>
                        <tr>
                            <td><?php echo $order_items['item_name'] ?></td>
                            <td><?php echo number_format($order_items['item_quantity'], 2, '.', '') ?></td>
                            <td><?php echo $order_items['unit_name'] ?></td>
                            <td align="right"><?php echo number_format($order_items['unit_price'], 2, '.', '') ?></td>
                            <td align="right">$ <?php echo number_format($order_items['total_item_price'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <th colspan="4">Subtotal</th>
                        <td width="100" align="right">$ <?php echo number_format($order_data['sub_total'], 2, '.', '') ?></td>
                    </tr>
                    <?php if ($order_data['gst_per'] != '0' && $order_data['gst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">GST (<?= $order_data['gst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($order_data['gst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($order_data['pst_per'] != '0' && $order_data['pst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">PST (<?= $order_data['pst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($order_data['pst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($order_data['hst_per'] != '0' && $order_data['hst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">HST (<?= $order_data['hst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($order_data['hst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($order_data['delivery_charges'] != '0' && $order_data['delivery_charges'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">Delivery Charges</th>
                            <td width="100" align="right">$ <?php echo number_format($order_data['delivery_charges'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($order_data['discount'] != '0' && $order_data['discount'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">Discount</th>
                            <td width="100" align="right">$ <?php echo number_format($order_data['discount'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <tr class="active">
                        <th colspan="4"><strong>Total Amount</strong></th>
                        <td width="100" align="right"><strong>$ <?php echo number_format($order_data['total_amount'], 2, '.', '') ?></strong></td>
                    </tr>
                    </tbody>
                </table> 
                <div class="clearfix"></div>                
            </div>
            <div class="col-md-4">
                <table class="table">
                    <tr class="heading-tr">
                        <th colspan="2">Customer Detail</th>
                    </tr>
                    <tr>
                        <th>Order ID :</th>
                        <td><?php echo 'A1-' . $order_data['order_id'] ?></td>
                    </tr>
                    <tr>
                        <th>Name :</th>
                        <td><?php echo $order_data['name'] ?></td>
                    </tr>
                    <tr>
                        <th>Tel :</th>
                        <td><?php echo $order_data['phone'] ?></td>
                    </tr>
                    <tr>
                        <th>Email :</th>
                        <td><?php echo $order_data['email'] ?></td>
                    </tr>
                    <tr>
                        <th>Address:</th>
                        <td><?php echo $order_data['address'] ?></td>
                    </tr>
                    <tr>
                        <th>City :</th>
                        <td><?php echo $order_data['city'] ?></td>
                    </tr>
                    <tr>
                        <th>Order Location :</th>
                        <td><?php echo $order_data['location_name'] ?></td>
                    </tr>
                    <tr>
                        <th><?php echo $order_data['delivery_type'] ?> Location:</th>
                        <td><?php echo $order_data['delivery_location_name'] ?></td>
                    </tr>
                    <tr>
                        <th><?php echo $order_data['delivery_type'] ?> Date :</th>
                        <td><?php echo date('m/d/Y', $order_data['delivery_date']) ?></td>
                    </tr>
                    <tr>
                        <th><?php echo $order_data['delivery_type'] ?> Time :</th>
                        <td><?php echo date('h:i A', $order_data['delivery_time']) ?></td>
                    </tr>
                    <tr>
                        <th>Comments :</th>
                        <td><?php echo $order_data['comments'] ?></td>
                    </tr>
                </table>
                <a href="<?= site_url('online-order') ?>" class="btn btn-default">Continue Shopping</a>
            </div>
        </div>
    </div>
</section>