<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1>Order Confirmation</h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active">Order Confirmation</li>
        </ol>
    </div>
</section>   
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="section-heading">Items Detail</h2>
                <table class="table order-table table-bordered">
                    <tr>
                        <th>Item Name</th>
                        <th>Qty.</th>
                        <th>Unit</th>
                        <th align="right">Price</th>
                        <th align="right">Total Price</th>
                    </tr>
                    <?php
                    foreach ($cart_items_data as $cart_items) {
                        ?>
                        <tr>
                            <td><?php echo $cart_items['item_name'] ?></td>
                            <td><?php echo number_format($cart_items['item_quantity'], 2, '.', '') ?></td>
                            <td><?php echo $cart_items['unit_name'] ?></td>
                            <td align="right"><?php echo number_format($cart_items['unit_price'], 2, '.', '') ?></td>
                            <td align="right">$ <?php echo number_format($cart_items['total_item_price'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <th colspan="4">Subtotal</th>
                        <td width="100" align="right">$ <?php echo number_format($cart_data['sub_total'], 2, '.', '') ?></td>
                    </tr>
                    <?php if ($cart_data['gst_per'] != '0' && $cart_data['gst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">GST (<?= $cart_data['gst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['gst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['pst_per'] != '0' && $cart_data['pst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">PST (<?= $cart_data['gst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['pst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['hst_per'] != '0' && $cart_data['hst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">HST (<?= $cart_data['hst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['hst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['delivery_charges'] != '0' && $cart_data['delivery_charges'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">Delivery Charges</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['delivery_charges'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['discount'] != '0' && $cart_data['discount'] != '0.00') { ?>
                        <tr>
                            <th colspan="4">Discount</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['discount'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <tr class="active">
                        <th colspan="4"><strong>Total Amount</strong></th>
                        <td width="100" align="right"><strong>$ <?php echo number_format($cart_data['total_cart_price'], 2, '.', '') ?></strong></td>
                    </tr>
                    </tbody>
                </table> 
                <div class="clearfix"></div>                
                <a href="<?= site_url('online-order/cancil-order') ?>" class="btn btn-primary">Cancel Order</a>
            </div>
            <div class="col-md-4">
                <table class="table">
                    <tr class="heading-tr">
                        <th colspan="2">Customer Detail</th>
                    </tr>
                    <tr>
                        <th>Name :</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['name'] ?></td>
                    </tr>
                    <tr>
                        <th>Tel :</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['phone'] ?></td>
                    </tr>
                    <tr>
                        <th>Email :</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['email'] ?></td>
                    </tr>
                    <tr>
                        <th>Order Location :</th>
                        <td><?php echo $this->common_model->getSingleFieldFromAnyTable('province_name', 'province_id', $this->session->userdata('location_id'), 'tbl_province'); ?></td>
                    </tr>
                    <tr>
                        <?php if($this->session->userdata($this->session->userdata('my_session_id'))['delivery_type']=='pickup') { ?>
                        <th><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['delivery_type'] ?> Location:</th>
                        <td><?php echo $this->common_model->getSingleFieldFromAnyTable('province_name', 'province_id', $this->session->userdata($this->session->userdata('my_session_id'))['delivery_location_id'], 'tbl_province'); ?></td>
                        <?php } else if($this->session->userdata($this->session->userdata('my_session_id'))['delivery_type']=='delivery') { ?>
                        <th><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['delivery_type'] ?> Location:</th>
                        <td><?php echo $this->common_model->getSingleFieldFromAnyTable('area_name', 'area_id', $this->session->userdata($this->session->userdata('my_session_id'))['area_id'], 'tbl_area_wise_delivery_charges'); ?></td>
                        <?php } ?>
                    </tr>
                    <tr>
                        <th>Address:</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['address'] ?></td>
                    </tr>
<!--                    <tr>
                        <th>Address 2 :</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['address2'] ?></td>
                    </tr>-->
                    <tr>
                        <th>City :</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['city'] ?></td>
                    </tr>
                    <tr>
                        <th><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['delivery_type'] ?> date :</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['delivery_date'] ?></td>
                    </tr>
                    <tr>
                        <th><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['delivery_type'] ?> Time :</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['delivery_time'] ?></td>
                    </tr>
                    <tr>
                        <th>Payment Type :</th>
                        <td><?php echo str_replace('_', ' ', $this->session->userdata($this->session->userdata('my_session_id'))['payment_type']) ?><?php ($this->session->userdata($this->session->userdata('my_session_id'))['payment_type']=='cash_on_delivery'?'(Order is not confirmed without deposit)':'') ?></td>
                    </tr>
                    <tr>
                        <th>Comments :</th>
                        <td><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['comments'] ?></td>
                    </tr>
                </table>
                <a href="<?= site_url('online-order') ?>" class="btn btn-default">Continue Shopping</a>
                <a href="<?= site_url('online-order/order-complete') ?>" class="btn btn-primary">Confirm Order</a>
            </div>
        </div>
    </div>
</section>