<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1><?php echo $page_heading ?></h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active"><?php echo trim($breadcumb, '/ ') ?></li>
        </ol>
    </div>
</section>
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="form-horizontal">
                    <div class="form-group categoryDropdown">
                        <label class="control-label col-sm-6">Choose Category</label>
                        <div class="col-sm-6">
                            <div class="btn-group">
                                <button aria-expanded="false" data-toggle="dropdown" class="btn btn-primary btn-block dropdown-toggle" type="button">
                                    <?= $category_detail->online_cat_name ?> <span class="caret"></span>
                                </button>
                                <ul role="menu" class="dropdown-menu">
                                    <?php
                                    if ($online_category) {
                                        foreach ($online_category as $online_cat) {
                                            ?>
                                            <li><a href="<?= site_url('online-order/' . $online_cat['slug']) ?>"><?= $online_cat['online_cat_name'] ?></a></li>
                                            <?php
                                        }
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <ul class="media-list dishlist">
                    <?php
                    $i = 0;
                    foreach ($online_item_list as $online_item) {
                        ?>
                        <li class="media">
                            <div class="media-left">
                                <img src="<?= $this->config->item('uploads') ?>online_item_images/<?= $online_item['item_image'] ?>" class="img-responsive">
                            </div>
                            <div class="media-body">
                                <form method="POST" class="online_order_form">

                                    <h4 class="media-heading"><?= $online_item['item_name'] ?></h4>
                                    <p><?= $online_item['item_description'] ?></p>
                                    <div class="clearfix"></div>
    <!--                                <table class="table">
                                        <tbody>
                                            <tr>
                                    <?php
                                    $unit_data = $this->onlineItem->getUnitsByOnlineItemId($online_item['online_item_id']);
                                    foreach ($unit_data as $unit) {
                                        ?>
                                                                    <tr>
                                                                        <td width="20"><input type="checkbox" class="item_size" name="unit_id[<?= $i ?>]" value="<?= $unit->unit_id ?>"></td>
                                                                        <td><?= $unit->unit_name ?></td>
                                                                        <td  data-default-price="<?= $unit->unit_prices ?>" class="total_item_price">$ <?= $unit->unit_prices ?></td>
                                                                        <td width="100" align="right">
                                                                            <div class="input-group">
                                                                                <span class="input-group-btn">
                                                                                    <button class="btn btn-default quantity_decrease" type="button">-</button>
                                                                                </span>
                                                                                <input type="text" class="form-control product_quantity" name="quantity" value="1" data-attr-price="<?= $online_item['item_price'] ?>">
                                                                                <span class="input-group-btn">
                                                                                    <button class="btn btn-default quantity_increase" type="button">+</button>
                                                                                </span>
                                                                            </div>
                                                                        </td> 
                                                                    </tr>
                                        <?php
                                    }
                                    ?>
                                                            <td class="product_price"><strong>$ <?= number_format($online_item['item_price'], 2, '.', '') ?></strong></td>
                                            <td width="100" align="right">
                                                <div class="input-group">
                                                    <span class="input-group-btn">
                                                        <button class="btn btn-default quantity_decrease" type="button">-</button>
                                                    </span>
                                                    <input type="text" class="form-control product_quantity" name="quantity" value="1" data-attr-price="<?= $online_item['item_price'] ?>">
                                                    <span class="input-group-btn">
                                                        <button class="btn btn-default quantity_increase" type="button">+</button>
                                                    </span>
                                                </div>
                                            </td>   
                                          
                                        </tbody>
                                    </table>-->
                                    <table class="table">
                                        <tbody>
                                            <tr>
                                                <td width="150">
                                                    <label>
                                                        <?php if (count($unit_data) == 1) { ?>

                                                            <input type="hidden" value="<?= $unit_data[0]->unit_id ?>" name="unit_id[]" >

                                                        <?php } else { ?>
                                                            <select style="margin-left: 0px;" class="product_attribute form-control" name="unit_id[]" required>
                                                                <option value="0">Select Size</option>
                                                                <?php foreach ($unit_data as $unit) { ?>
                                                                    <option value="<?= $unit->unit_id ?>" data-product-price="<?= number_format($unit->unit_prices, 2, '.', '') ?>"> <?= $unit->unit_name ?></option>
                                                                <?php } ?> 
                                                            </select>
                                                        <?php } ?>
                                                    </label>
                                                </td>
                                                <td width="100" class="product_price" width="80" style="font-weight: bold; text-align: right;">$ <?= (count($unit_data) == 1) ? number_format($unit_data[0]->unit_prices, 2, '.', '') : number_format(0, 2, '.', '') ?></td>
                                                <td width="20">
                                                    <div class="input-group" style="width:98px; float: right;">
                                                        <span class="input-group-btn">
                                                            <button class="btn btn-default quantity_decrease" type="button">-</button>
                                                        </span>
                                                        <input type="text" class="form-control product_quantity" name="quantity" value="1" data-attr-price="<?= number_format($unit->unit_prices, 2, '.', '') ?>">
                                                        <span class="input-group-btn">
                                                            <button class="btn btn-default quantity_increase" type="button">+</button>
                                                        </span>
                                                    </div>
                                                </td>    
                                            </tr>

                                        </tbody>
                                    </table>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <label>Product Note:</label>
                                        </div>
                                        <div class="col-md-6">
                                            <textarea style="resize: none;" class="form-control" name="product_note"></textarea>
                                        </div>
                                        <div class="col-md-3">
                                            <input type="hidden" name="item_id" value="<?= $online_item['online_item_id'] ?>">
                                        </div>
                                    </div>
                                    <input class="btn btn-primary pull-right add_online_item_to_cart" type="button" value="Add to Cart">
                                </form>
                            </div>

                        </li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-md-4 sidebarCart">
                <?= $this->load->view('online_order/sidebar_cart'); ?>
            </div>
        </div>
    </div>
</section>

<script>
    $('body').delegate('.add_online_item_to_cart', 'click', function () {
    $('.loader').addClass('show_loader');
    // var item_id = $(this).attr('data-attr-item-id');
//    alert(item_id);die;
    var $this = $(this);
    var formInput = $this.parent().parent().find('form.online_order_form').serialize();
    $.post(baseurl + "add_online_item_to_cart", formInput, function (data) {
        $('.sidebarCart').html(data.page_content);
        $('#header_cart_count').html(data.cart_items);
        $('input:checkbox').removeAttr('checked');
        $('.add_item_to_cart').prop("disabled", true);
    }, "json");

});
    $('body').delegate('.amount_increase', 'click', function () {
        $('.loader').addClass('show_loader');
        var cart_item_id = $(this).attr('data-cart-item-id');
        var $this = $(this);
        if (cart_item_id != '0')
        {
            $.ajax({
                type: "POST",
                async: 'false',
                dataType: "json",
                url: baseurl + "online-order/increment-product",
                data: {"cart_item_id": cart_item_id},
                success: function (msg) {
                    $('.sidebarCart').html(msg.sidebar_cart);
                }
            })
        }
    });
    $('body').delegate('.delete_item', 'click', function () {
        $('.loader').addClass('show_loader');
        var cart_item_id = $(this).attr('data-cart-item-id');
        var $this = $(this);
        if (cart_item_id != '0')
        {
            $.ajax({
                type: "POST",
                async: 'false',
                url: baseurl + "online-order/delete-cart-item",
                data: {"cart_item_id": cart_item_id},
                success: function (msg) {
                    $('.sidebarCart').html(msg.cart_data);
                    $('#header_cart_count').html(msg.cart_items);
                }
            })
        }
    });
    $('body').delegate('.amount_decrease', 'click', function () {
        $('.loader').addClass('show_loader');
        var cart_item_id = $(this).attr('data-cart-item-id');
        var $this = $(this);
        if (cart_item_id != '0')
        {
            $.ajax({
                type: "POST",
                async: 'false',
                url: baseurl + "online-order/decrement-product",
                data: {"cart_item_id": cart_item_id},
                success: function (msg) {
                    $('.sidebarCart').html(msg);
                }
            })
        }
    });
    $(document).ready(function () {
        $(".optiontab").click(function () {
            $("#optioncheck").slideToggle(1000);
        });
    });
</script>
<script>
    $("body").delegate(".item_size", "click", function () {
        var checked_items = $(this).parent().parent().parent().parent().find('input.item_size:checked').length;
        if (checked_items > 0) {
            $('.add_item_to_cart').prop("disabled", false);
        } else {
            $('.add_item_to_cart').prop("disabled", true);
        }
    });
    $("body").delegate(".product_attribute", "change", function () {
        var product_price = $("option:selected", $(this)).attr('data-product-price');
        //  var product_people = $("option:selected", $(this)).attr('data-product-people');
        if ($(this).val() != '0') {
            //  $(this).parent().parent().parent().find('.product_attribute_people').val(product_people);
            $(this).parent().parent().parent().find('.product_price').text('$ ' + product_price);
            $(this).parent().parent().parent().parent().parent().parent().find('.add_to_cart').prop("disabled", false);
            $(this).parent().parent().parent().find('.product_quantity').attr("data-attr-price", product_price);
        } else {
            //$(this).parent().parent().parent().find('.product_attribute_people').val(0);
            $(this).parent().parent().parent().find('.product_price').text('$ 0.00');
            $(this).parent().parent().parent().parent().parent().parent().find('.add_to_cart').prop("disabled", true);
            $(this).parent().parent().parent().find('.product_quantity').attr("data-attr-price", 0);
        }
    });
    $("body").delegate(".quantity_decrease", "click", function () {
        var quantity = $(this).parent().parent().find('.product_quantity').val();
        var price = $(this).parent().parent().find('.product_quantity').attr('data-attr-price');
        quantity = parseInt(quantity) - parseInt(1);
        var final_price = quantity * price;
        if (!$(this).parent().parent().find('.product_quantity').prop('disabled') && quantity > 0) {
            $(this).parent().parent().find('.product_quantity').val(quantity);
            $(this).parent().parent().parent().parent().find('.product_price').html('$' + parseFloat(final_price).toFixed(2));
        }
    });
    $("body").delegate(".quantity_increase", "click", function () {
        var quantity = $(this).parent().parent().find('.product_quantity').val();
        var price = $(this).parent().parent().find('.product_quantity').attr('data-attr-price');
        quantity = parseInt(quantity) + parseInt(1);
        var final_price = quantity * price;
        if (!$(this).parent().parent().find('.product_quantity').prop('disabled')) {
            $(this).parent().parent().find('.product_quantity').val(quantity);
            $(this).parent().parent().parent().parent().find('.product_price').html('$' + parseFloat(final_price).toFixed(2));
        }
    });
</script>
<?php if ($this->session->flashdata('cart_coupon_messages')) { ?>
    <script>
        bootbox.alert("<?php echo $this->session->flashdata('cart_coupon_messages') ?>");
    </script>
<?php } ?>