<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>

<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1><?php echo $breadcrumb ?></h1>
        <ol class="breadcrumb">
            <li><a href="<?php site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active"><?php echo $breadcrumb ?></li>
        </ol>
    </div>
</section>  

<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="form-horizontal">
                    <div class="form-group categoryDropdown">
                        <label class="control-label col-sm-6">Choose Category</label>
                        <div class="col-sm-6">
                            <div class="btn-group">
                                <button aria-expanded="false" data-toggle="dropdown" class="btn btn-primary btn-block dropdown-toggle" type="button">
                                    <?= $category_detail->online_cat_name ?> <span class="caret"></span>
                                </button>
                                <ul role="menu" class="dropdown-menu">
                                    <?php
                                    if ($online_category) {
                                        foreach ($online_category as $online_cat) {
                                            ?>
                                            <li><a href="<?= site_url('online-order/' . $online_cat['slug']) ?>"><?= $online_cat['online_cat_name'] ?></a></li>
                                            <?php
                                        }
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                $i = 1;
                foreach ($online_categories as $online_category) {
                    $package_data = $this->package->getPackageRecords('meal', $online_category['online_cat_id']);
                    // print_r($package_data);die;
                    if ($package_data) {
                        ?>
                        <div class="row well meal-row">
                            <div class="col-xs-12"><h3 class="meal-title"><?= $online_category['online_cat_name'] ?></h3></div>

                            <div class="meal-carousel" id="meal-carousel_<?php echo $i; ?>">
                                <?php
                                foreach ($package_data as $package) {
                                    ?>
                                    <div class="menubox ourmenu">
                                        <a href="<?= site_url('online-order/meals-detail/' . $package['package_id']) ?>">
                                            <div class="menu_img">
                                                <img src="<?= $this->config->item('uploads') ?>meal_images/<?php echo $package['package_image'] ?>" class="img-responsive">
                                                <h3><?php echo $package['name'] ?></h3>
                                            </div>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                            <a href="javascript:void(0);" id="meal_prev_<?php echo $i; ?>" class="prev fa fa-angle-left">&nbsp;</a>
                            <a href="javascript:void(0);" id="meal_next_<?php echo $i; ?>" class="next fa fa-angle-right">&nbsp;</a>
                        </div>
                        <script type="text/javascript">
                            $('#meal-carousel_<?php echo $i; ?>').carouFredSel({
                                width: '100%',
                                prev: '#meal_prev_<?php echo $i; ?>',
                                next: '#meal_next_<?php echo $i; ?>',
                                autoplay: false,
                                scroll:
                                        {
                                            duration: 500,
                                            items: 1
                                        }
                            });
                        </script>
                        <?php
                        $i++;
                    }
                }
                ?>
                <?php if ($this->session->userdata('packageErrorMessage')) { ?>
                    <div class="alert alert-danger">
                        <?= $this->session->userdata('packageErrorMessage') ?>   
                    </div>
                    <?php
                    $this->session->unset_userdata('packageErrorMessage');
                }
                ?> 
            </div>
            <div class="col-md-4 sidebarCart">
                <?= $this->load->view($this->config->item('template') . '/sidebar_cart'); ?>
            </div>
        </div>           
    </div>
</section>