<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1>Checkout</h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active">Cart</li>
        </ol>
    </div>
</section>  
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h2 class="section-heading">Items Detail</h2>
                <table class="table order-table table-bordered">
                    <tr>
                        <th>Item Name</th>
                        <th>Delete</th>
                        <th>Qty.</th>
                        <th>Unit</th>
                        <th>Price</th>
                        <th align="right">Total Price</th>
                    </tr>
                    <?php
                    if($cart_items_data && !empty($cart_items_data)) {
                    foreach ($cart_items_data as $cart_items) {
                        ?>
                        <tr>
                            <td><?php echo $cart_items['category_name'] ?> <?php echo $cart_items['item_name'] ?><?php if ($cart_items['item_type'] == 'package') { ?>
                                    <a href="<?= site_url('online-order/get-cart-package-items/' . $cart_items['cart_item_id']) ?>" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>" class="fancybox fancybox.iframe btn btn-default btn-sm" >View Your package Detail</a>
                                <?php } ?></td>
                            <td><a href="javascript:;" class="delete_cart_item" data-cart-item-id="<?= $cart_items['cart_item_id'] ?>"><i class="fa fa-trash-o"></i></a></td>
                            <td><?php echo number_format($cart_items['item_quantity'], 2, '.', '') ?></td>
                            <td><?php echo $cart_items['unit_name'] ?></td>
                            <td align="right">$ <?php echo number_format($cart_items['unit_price'], 2, '.', '') ?></td>
                            <td align="right">$ <?php echo number_format($cart_items['total_item_price'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <tr>
                        <th colspan="5" align="right">Subtotal</th>
                        <td width="100" align="right">$ <?php echo number_format($cart_data['sub_total'], 2, '.', '') ?></td>
                    </tr>
                    <?php if ($cart_data['gst_per'] != '0' && $cart_data['gst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="5">GST (<?= $cart_data['gst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['gst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['pst_per'] != '0' && $cart_data['pst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="5">PST (<?= $cart_data['gst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['pst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['hst_per'] != '0' && $cart_data['hst_per'] != '0.00') { ?>
                        <tr>
                            <th colspan="5">HST (<?= $cart_data['hst_per'] ?> %)</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['hst'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <?php if ($cart_data['discount'] != '0' && $cart_data['discount'] != '0.00') { ?>
                        <tr>
                            <th colspan="5">Discount</th>
                            <td width="100" align="right">$ <?php echo number_format($cart_data['discount'], 2, '.', '') ?></td>
                        </tr>
                    <?php } ?>
                    <tr class="active">
                        <th colspan="5"><strong>Total Amount</strong></th>
                        <td width="100" align="right"><strong>$ <?php echo number_format($cart_data['total_cart_price'], 2, '.', '') ?></strong></td>
                    </tr>
                    </tbody>
                    <?php } else { ?>
                    <tr class="active">
                        <td colspan="6"><center>Your cart is Empty</center></td>
                    </tr>
                    <?php } ?>
                </table> 
                <div class="clearfix"></div>                
                <a href="<?= site_url('online-order/cancel-order') ?>" class="btn btn-primary">Empty cart</a>
                <a href="<?= site_url('online-order') ?>" class="btn btn-primary">Continue Shopping</a>
                <a href="<?= site_url('online-order/checkout') ?>" class="btn btn-primary pull-right">Checkout</a>
            </div>
        </div>
    </div>
</section>
<script src="<?= $this->config->item('frontassets') ?>js/catering.js"></script>
<script>
    $('.datepicker').datetimepicker({pickTime: false});
    $('.timepicker').datetimepicker({
        pickDate: false,
        pick12HourFormat: true
    });
    $('.datetimepicker').datetimepicker({pick12HourFormat: true});
    $("body").delegate(".delivery_type", "click", function () {
        $('.order_area_id').attr('disabled', false);
        $('.order_area_id').prop('required', true);
        $(".pickup_type").addClass('active');
        $(this).removeClass('active');
        $("#delivery_type").val('delivery');
    });
    $("body").delegate(".pickup_type", "click", function () {
        $('.order_area_id').attr('disabled', true);
        $('.order_area_id').prop('required', false);
        $(".delivery_type").addClass('active');
        $(this).removeClass('active');
        $("#delivery_type").val('pickup');
    });

    $('body').delegate('.delete_cart_item', 'click', function () {
        var cart_item_id = $(this).attr('data-cart-item-id');
        var $this = $(this);
        if (cart_item_id != '0')
        {
            $.ajax({
                type: "POST",
                async: 'false',
                url: baseurl + "online-order/delete-cart-item",
                data: {"cart_item_id": cart_item_id},
                success: function (msg) {
                    location.reload();
                }
            })
        }
    });
</script>