<?php
$current_url = current_url();
$meta_tags = $this->common_model->getMetaTitle($current_url);
$header_image = $this->config->item('uploads') . 'header_images/' . $meta_tags['header_image'];
$background_image = $this->config->item('uploads') . 'background_images/' . $meta_tags['background_image'];
?>
<section class="page-heading" <?php if ($meta_tags['header_image'] != '') { ?> style='background-image: url("<?= $header_image ?>");' <?php } ?> >
    <div class="container">
        <h1>Checkout</h1>
        <ol class="breadcrumb">
            <li><a href="<?= site_url() ?>"><i class="fa fa-home"></i></a></li>
            <li class="active">Checkout</li>
        </ol>
    </div>
</section>  
<section class="MainContent" <?php if ($meta_tags['background_image'] != '') { ?> style='background-image: url("<?= $background_image ?>");' <?php } ?>>
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <h2 class="section-heading">Checkout</h2>
                <form role="form" method="post" class="well" action="<?= site_url('online-order/order-confirmation') ?>">
                    <div class="row form-group">
                        <div class="col-md-6">
                            <label>Name</label>
                            <input type="text" name="name" required placeholder="Name" class="form-control" value="<?php echo $this->session->userdata($this->session->userdata('my_session_id'))['name'] ?>">
                        </div>
                        <div class="col-md-6">
                            <label>Order type: </label><br>
                            <div class="pick_del_links">
                                <a href="javascript:;" class="pickup_type <?= ($this->session->userdata($this->session->userdata('my_session_id'))['delivery_type']) == 'pickup' ? 'active' : '' ?>"><img src="<?= base_url() ?>/assets/frontend/img/Pickup.png" class="pickup" alt="Pickup"></a>
                                <a href="javascript:;" class="delivery_type <?= ($this->session->userdata($this->session->userdata('my_session_id'))['delivery_type']) == 'delivery' ? 'active' : '' ?>"><img src="<?= base_url() ?>/assets/frontend/img/Delivery.png" class="delivery" alt="Delivery"></a>
                                <input type="hidden" id="delivery_type" name="delivery_type" value="<?php echo ($this->session->userdata($this->session->userdata('my_session_id'))['delivery_type']) ? $this->session->userdata($this->session->userdata('my_session_id'))['delivery_type'] : 'pickup' ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-6">
                            <label>Email: </label>
                            <input type="text" placeholder="Email" required class="form-control" name="email" value="<?php echo $this->session->userdata($this->session->userdata('my_session_id'))['email'] ?>">
                        </div>

                        <div class="col-md-6">
                            <label id="location_label">Pickup Location: </label>
                            <?php $location_list = $this->common_model->getAllLocation(); ?>
                            <select name="delivery_location_id" class="form-control order_location_id" required>
                                <option value="0">Select Location</option>
                                <?php foreach ($location_list as $location) { ?>
                                    <option value="<?= $location['province_id'] ?>" <?php echo ($this->session->userdata($this->session->userdata('my_session_id'))['delivery_location_id'] == $location['province_id'] || $this->session->userdata('location_id') == $location['province_id'] ) ? 'selected' : '' ?>><?= $location['province_name'] ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-6">
                            <label>Telephone:</label>
                            <input type="text" placeholder="Tel" required class="form-control" name="phone" value="<?php echo $this->session->userdata($this->session->userdata('my_session_id'))['phone'] ?>">
                        </div>
                        <div class="col-md-6">
                            <label>Delivery Area: </label>                          
                            <select name="area_id" class="form-control order_area_id" <?php echo ($this->session->userdata($this->session->userdata('my_session_id'))['delivery_type'] == 'delivery') ? 'required' : 'disabled' ?>>
                                <option value="">Select Area</option> 
                                <?php foreach ($area_list as $area) { ?>
                                    <option <?php echo ($this->session->userdata($this->session->userdata('my_session_id'))['area_id'] == $area['area_id']) ? 'selected' : '' ?> value="<?= $area['area_id'] ?>"><?= $area['area_name'] ?></option>
                                <?php } ?>                             
                            </select>
                            <p id="charges"></p>
                        </div>
                    </div>

                    <div class="row form-group">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <label>Address: </label>
                                    <textarea name="address" placeholder="Address" class="form-control" required><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['address'] ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <label id="time_label"><?php echo ($this->session->userdata($this->session->userdata('my_session_id'))['delivery_type'] == 'delivery') ? 'Delivery' : 'Pickup' ?> Time: </label>
                                    <div class="input-group timepicker">                        
                                        <input data-format="HH:mm" type="text" placeholder="Time" class="form-control" name="delivery_time" value="<?php echo $this->session->userdata($this->session->userdata('my_session_id'))['delivery_time'] ?>" required>
                                        <span class="input-group-addon"><i data-time-icon="fa-calendar" data-date-icon="fa-calendar"></i></span>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <label>Payment Type: <span class="order_type"></span></label><br>
                                    <input required type="radio" name="payment_type" value="cash_on_delivery" class="payment_type" <?php echo ($this->session->userdata($this->session->userdata('my_session_id'))['payment_type'] == 'cash_on_delivery') ? 'checked' : '' ?>> Cash On Delivery 
                                    <input required type="radio" name="payment_type" value="paypal" class="payment_type" <?php echo ($this->session->userdata($this->session->userdata('my_session_id'))['payment_type'] == 'paypal') ? 'checked' : '' ?>> Paypal 
                                    <p id="cash_on_del_note"></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-6">
                            <label>City:</label>
                            <input type="text" placeholder="City" required class="form-control" name="city" value="<?php echo $this->session->userdata($this->session->userdata('my_session_id'))['city'] ?>">
                        </div>
                        <div class="col-md-6">
                            <label id="date_label"><?php echo ($this->session->userdata($this->session->userdata('my_session_id'))['delivery_type'] == 'delivery') ? 'Delivery' : 'Pickup' ?> Date: </label>
                            <div class="input-group datepicker">                        
                                <input data-format="MM/dd/yyyy" type="text" placeholder="Date" class="form-control" name="delivery_date" value="<?php echo $this->session->userdata($this->session->userdata('my_session_id'))['delivery_date'] ?>" required>
                                <span class="input-group-addon"><i data-time-icon="fa-calendar" data-date-icon="fa-calendar"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-12">
                            <textarea placeholder="Comments" name="comments" rows="3" class="form-control"><?php echo $this->session->userdata($this->session->userdata('my_session_id'))['comments'] ?></textarea>
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-12">
                            <input type="checkbox" name="time_notice" value="yes" required> Need 48 hours Notice for all online order
                        </div>
                    </div>
                    <div class="row form-group">
                        <div class="col-md-12">
                            <input type="submit" value="Submit" class="btn btn-primary">
                            <img src="<?= base_url() ?>/assets/frontend/img/paypal.jpg" class="paypal">
                        </div>
                    </div>
                </form>
                <div class="clearfix"></div>
            </div>
            <div class="col-md-4 sidebarCart">
                <?= $this->load->view('online_order/sidebar_cart'); ?>
            </div>
        </div>
    </div>
</section>
<script src="<?= $this->config->item('frontassets') ?>js/catering.js"></script>
<script>
    $('.datepicker').datetimepicker({pickTime: false});
    $('.timepicker').datetimepicker({
        pickDate: false,
        pick12HourFormat: true
    });
    $('.datetimepicker').datetimepicker({pick12HourFormat: true});
    $("body").delegate(".delivery_type", "click", function() {
        $('.order_area_id').attr('disabled', false);
        $('.order_location_id').attr('disabled', true);
        $('.order_area_id').prop('required', true);
        $('.order_location_id').prop('required', false);
        $(".pickup_type").addClass('active');
        $(this).removeClass('active');
        $("#delivery_type").val('delivery');
        $("#date_label").text('Delivery Date:');
        $("#time_label").text('Delivery Time:');
       // $("#location_label").text('Delivery Location:');
    });
    $("body").delegate(".pickup_type", "click", function() {
        $('.order_area_id').attr('disabled', true);
        $('.order_location_id').attr('disabled', false);
        $('.order_area_id').prop('required', false);
        $('.order_location_id').prop('required', true);
        $(".delivery_type").addClass('active');
        $(this).removeClass('active');
        $("#delivery_type").val('pickup');
         $("#date_label").text('Pickup Date:');
        $("#time_label").text('Pickup Time:');
        $.ajax({
                type: "POST",
                async: true,
                url: baseurl + "ajax-area-charge",
                data: {
                    "area_id": 0
                },
                dataType: "json",
                success: function (data) {
                    if (data.success) {
                        // alert(data.charges);
                        $('#charges').text('Your area charges is: $ ' + data.charges);
                    } else {
                        $('#charges').text('');
                    }
                }
            });
       // $("#location_label").text('Pickup Location:');
    });
    $("body").delegate(".order_area_id", "change", function () {
        var area_id = $(this).val();
        if (area_id == '') {
            area_id=0;
        }
            $.ajax({
                type: "POST",
                async: true,
                url: baseurl + "ajax-area-charge",
                data: {
                    "area_id": area_id
                },
                dataType: "json",
                success: function (data) {
                    if (data.success) {
                        // alert(data.charges);
                        $('#charges').text('Your area charges is: $ ' + data.charges);
                    } else {
                        $('#charges').text('');
                    }
                }
            });
        
    });
    $("body").delegate(".payment_type", "click", function () {
        if ($(this).val() == 'cash_on_delivery') {
            $('#cash_on_del_note').text('Order is not confirmed without deposit');
        } else {
            $('#cash_on_del_note').text('');
        }
    });
</script>